/*
 * Created on 20-apr-2004
 */
package convFramework.traffic.event;

import convFramework.domain.*;

/**
 * Classe che modella un generico evento legato alla trasmissione di un pacchetto
 * @author Lompa
 */
public abstract class PacketTransmissionEvent extends ConvFrameworkEvent {
	
	private Packet transmittedPacket = null;
	
	/**
	 * Crea una istanza di PpacketTransmissionEvent
	 * @param source la sorgente dell'evento
	 * @param packet il pacchetto trasmesso
	 */
	public PacketTransmissionEvent(Object source, Packet packet){
		super(source);
		this.transmittedPacket = packet;
	}
	
	/**
	 * Restituisce il pacchetto trasmesso
	 * @return il pacchetto
	 */
	public Packet getTransmittedPacket(){
		return this.transmittedPacket;
	}
}
