/*
 * Created on 20-apr-2004
 */
package convFramework.traffic.event;

import convFramework.domain.*;

/**
 * Classe che modella un generico eventolegato all'arrivo di un pacchetto
 * @author Lompa
 */
public abstract class PacketArrivalEvent extends ConvFrameworkEvent {
	
	private Packet arrivePacket = null; 
	
	/**
	 * Crea una istanza di PpacketArrivalEvent
	 * @param source la sorgente dell'evento
	 * @param packet il pacchetto arrivato
	 */
	public PacketArrivalEvent(Object source, Packet packet){
		super(source);
		this.arrivePacket = packet;
	}
	
	/**
	 * Restituisce il pacchetto arrivato
	 * @return il pacchetto
	 */
	public Packet getArrivedPacket(){
		return this.arrivePacket;
	}
}
