/*
 * Created on 20-apr-2004
 */
package convFramework.traffic.event;

import convFramework.domain.*;

/**
 * Classe che modella un evento di inizio di un anuova conversazione ad opera di un nodo remoto
 * @author Lompa
 */
public class NewConversationEvent extends PacketArrivalEvent {
	
	/**
	 * Crea una istanza di NewConversationEvent 
	 * @param source la sorgente del'evento
	 * @param arrivedPacket il pacchetto la cui ricezione d inizio alla conversazione
	 */
	public NewConversationEvent(Object source, Packet arrivedPacket){
		super(source, arrivedPacket);
	}
	
	/**
	 * Restituisce l'id della conversazione iniziata
	 * @return
	 */
	public IConversationID getConversationID(){
		return this.getArrivedPacket().getConversationID();
	}
}
