/*
 * Created on 20-apr-2004
 */
package convFramework.traffic.event;

import convFramework.domain.*;
import convFramework.exceptions.*;

/**
 * Classe che modella un evento ddi arrivo di un pacchetoche risponde ad un altro pacchetto
 * @author Lompa
 */
public class AckArrivedEvent extends PacketArrivalEvent {
	
	/**
	 * Crea una istanza di AckArrivedEvent
	 * @param source la sorgente dell'evento
	 * @param arrivedPacket il pacchetto arrivato
	 * @throws BadInvocationArgumentException se il paccheto che si passa nel costruttore non  riferito ad un altro
	 */
	public AckArrivedEvent(Object source, Packet arrivedPacket) throws BadInvocationArgumentException{
		super(source, arrivedPacket);
		
		if (arrivedPacket.getAcknowledgedPacket() == null)
			throw new BadInvocationArgumentException("arrivedpacket", "Packet must be referre to another packet");
	}
	
	/**
	 * Restituisce l'id del pacchetto cui quelo corrente risponde
	 * @return l'id
	 */
	public IPacketID getReferredPacketID(){
		return this.getArrivedPacket().getAcknowledgedPacket();
	}
}
