/*
 * Created on 20-apr-2004
 */
package convFramework.traffic;

import convFramework.exceptions.*;
import convFramework.traffic.event.*;
import java.util.*;

/**
 * Gestore cui occorre registrare i listener degli eventi legati all'invio di pacchetti,
 * perch possnao esserne notificati. Ne pu esistere una sola istanza. La classe  predisposta per supportare
 * accessi concorrenti
 * @author Lompa
 */
public class TransmissionEventListenerManager {
	
	/* flag di istanziazione */
	//private static boolean instantiated = false;
	
	/* campi */
	private Vector transmissionErrorListeners = new Vector();
	private Vector packetTransmittedListeners = new Vector();
	private Vector missingResponseListeners = new Vector();
	
	/**
	 * Crea un istanza di TransmissionEventListenerManager
	 * @throws InstantiationRuleBrokenException se la classe  gi stata istanziata
	 */
	public TransmissionEventListenerManager() throws InstantiationRuleBrokenException{
		//if (instantiated)
		//	throw new InstantiationRuleBrokenException("Cannot create more than one TransmissionEventListenerManager");
		
		//instantiated = true;
	}
	
	/**
	 * Registra un nuovo gestore di errori di trasmissione
	 * @param listener il gestore
	 */
	public synchronized void addTransmissionErrorListener(ITransmissionErrorListener listener){
		this.transmissionErrorListeners.add(listener);
	}
	
	/**
	 * Deregistra un gestore di errori di trasmissione, se presente
	 * @param listener il gestore
	 */
	public synchronized void removeTransmissionErrorListener(ITransmissionErrorListener listener){
		this.transmissionErrorListeners.remove(listener);
	}
	
	/**
	 * Registra un nuovo gestore per l'invio di pacchetti
	 * @param listener il gestore
	 */
	public synchronized void addPacketTransmittedListener(IPacketTransmittedListener listener){
		this.packetTransmittedListeners.add(listener);
	}
	
	/**
	 * Se presente, deregistra un gestore della'invio di pacchetti
	 * @param listener il gestore
	 */
	public synchronized void removePacketTransmittedListener(IPacketTransmittedListener listener){
		this.packetTransmittedListeners.remove(listener);
	}
	
	public synchronized void addMissingAckListener(IMissingAckListener listener){
		this.missingResponseListeners.add(listener);
	}
	
	public synchronized void removeMissingAckListener(IMissingAckListener listener){
		this.missingResponseListeners.remove(listener);
	}
	
	public synchronized ITransmissionErrorListener[] getTransmissionErrorListeners(){
		ITransmissionErrorListener[] listeners = new ITransmissionErrorListener[this.transmissionErrorListeners.size()];
		this.transmissionErrorListeners.toArray(listeners);
		return listeners;
	}
	
	public synchronized IPacketTransmittedListener[] getPacketTransmittedListeners(){
		IPacketTransmittedListener[] listeners = new IPacketTransmittedListener[this.packetTransmittedListeners.size()];
		this.packetTransmittedListeners.toArray(listeners);
		return listeners;
	}
	
	public synchronized IMissingAckListener[] getMissingAckListeners(){
		IMissingAckListener[] listeners = new IMissingAckListener[this.missingResponseListeners.size()];
		this.missingResponseListeners.toArray(listeners);
		return listeners;
	}		
	
}
