/*
 * Created on 20-apr-2004
 */
package convFramework.traffic;

import convFramework.exceptions.*;
import convFramework.traffic.event.*;
import java.util.*;

/**
 * Gestore cui occorre registrare i listener degli eventi legati all'arrivo di pacchetti,
 * perch possnao esserne notificati. Ne pu esistere una sola istanza. La classe  predisposta per supportare
 * accessi concorrenti
 * @author Lompa
 */
public class ReceptionEventListenerManager {
	
	/* flag di istanziazione */
	//private static boolean instantiated = false;
	
	/* campi */
	private Vector receptionErrorListeners = new Vector();
	private Vector packetArrivedListeners = new Vector();
	private Vector responseArrivedListeners = new Vector();
	private Vector newConversationListeners = new Vector();
	
	/**
	 * Crea un istanza di A3EventListenerManager
	 * @throws InstantiationRuleBrokenException se la classe  gi stata istanziata
	 */
	public ReceptionEventListenerManager() throws InstantiationRuleBrokenException{
		//if (instantiated)
		//	throw new InstantiationRuleBrokenException("Cannot create more than one A3EventListenerManager");
		
		//instantiated = true;
	}
	
	/**
	 * Registra un nuovo gestore di errori di ricezione
	 * @param listener il gestore
	 */
	public synchronized void addReceptionErrorListener(IReceptionErrorListener listener){
		this.receptionErrorListeners.add(listener);
	}
	
	/**
	 * Deregistra un gestore di errori di ricezione, se presente
	 * @param listener il gestore
	 */
	public synchronized void removeReceptionErrorListener(IReceptionErrorListener listener){
		this.receptionErrorListeners.remove(listener);
	}
	
	/**
	 * Registra un nuovo gestore per l'arrivo di pacchetti
	 * @param listener il gestore
	 */
	public synchronized void addContentPacketArrivedListener(IContentPacketArrivedListener listener){
		this.packetArrivedListeners.add(listener);
	}
	
	/**
	 * Se presente, deregistra un gestore della'rrivo di pacchetti
	 * @param listener il gestore
	 */
	public synchronized void removeContentPacketArrivedListener(IContentPacketArrivedListener listener){
		this.packetArrivedListeners.remove(listener);
	}
	
	public synchronized void addAckArrivedListener(IAckArrivedListener listener){
		this.responseArrivedListeners.add(listener);
	}
	
	public synchronized void removeAckArrivedListener(IAckArrivedListener listener){
		this.responseArrivedListeners.remove(listener);
	}
	
	public synchronized void addNewConversationListener(INewConversationListener listener){
		this.newConversationListeners.add(listener);
	}
	
	public synchronized void removeNewConversationListener(INewConversationListener listener){
		this.newConversationListeners.remove(listener);
	}
	
	public synchronized IReceptionErrorListener[] getReceptionErrorListeners(){
		IReceptionErrorListener[] listeners = new IReceptionErrorListener[this.receptionErrorListeners.size()];
		this.receptionErrorListeners.toArray(listeners);
		return listeners;
	}
	
	public synchronized IContentPacketArrivedListener[] getContentPacketArrivedListeners(){
		IContentPacketArrivedListener[] listeners = new IContentPacketArrivedListener[this.packetArrivedListeners.size()];
		this.packetArrivedListeners.toArray(listeners);
		return listeners;
	}
	
	public synchronized IAckArrivedListener[] getAckArrivedListeners(){
		IAckArrivedListener[] listeners = new IAckArrivedListener[this.responseArrivedListeners.size()];
		this.responseArrivedListeners.toArray(listeners);
		return listeners;
	}	
	
	public synchronized INewConversationListener[] getNewConversationListeners(){
		INewConversationListener[] listeners = new INewConversationListener[this.newConversationListeners.size()];
		this.newConversationListeners.toArray(listeners);
		return listeners;
	}	
	
}
