/*
 * Created on 20-apr-2004
 */
package convFramework.traffic;

import java.util.*;

import convFramework.exceptions.*;
import convFramework.domain.*;

/**
 * Buffer in cui vengono depositati i pacchetti a spedire; ne pu essere presente una sola istanza
 * @author Lompa
 */
public class OutQueue {
	
	/* campi */
	private LinkedList buffer = new LinkedList(); 
	
	
	public OutQueue() throws InstantiationRuleBrokenException{
	}
	
	/**
	 * Inserisce un pacchetto perch sia inviato
	 * @param packet il pacchetto
	 */	
	public synchronized void insertPacket(Packet packet){
		buffer.add(packet);
		this.notify();
	}
	
	/**
	 * Estra un pacchetto dalla coda
	 * @return il pacchetto estratto
	 */
	public synchronized Packet extractPacket() throws InterruptedException{
		if (buffer.isEmpty()) this.wait();
		return (Packet) buffer.removeFirst();
	}
	
}
