/*
 * Created on 18-apr-2004
 *
 */
package convFramework.traffic;

import convFramework.domain.*;
import convFramework.exceptions.*;

/**
 * INterfaccia che caratterizza un unmarshaller per il framework
 * @author Lompa
 */
public interface IUnMarshaller {
	
	/**
	 * Inizializza un pacchetto co le informazioni recuperate da una sequenza di byte risultante
	 * dal marshallling di un altro pacchetto
	 * Utilizzare un modello  necessario perch non tutte le propriet di un pacchetto possono
	 * essere recuperate dal suo contenuto: ad esempio non si possono ottenre in questo modo
	 * il mittente ed il destinatario
	 * @param content il contenuto di cui fare l'unmarshalling
	 * @param basePacket il pacchetto che fa da modello per linizializzazione
	 * @return 
	 */
	public Packet unMarshall(byte[] content) throws MarshallingException;

}
