/*
 * Created on 20-apr-2004
 */
package convFramework.traffic;

import convFramework.domain.*;
import convFramework.exceptions.*;
import java.util.*;

/**
 * Classe che mantine informazioni sulle conversazioni attive; le conversaazioni vengono memorizzte in una mappa
 * ed indicizzate in base al loro id codificato.
 * La classe  predisposta per supportare accessi concorrenti (tutti i metodi sono sincronizazti)
 * @author Lompa
 */
public class ConversationManager {
	
	/* flag di istanzizzione */
	//static boolean instantiated = false;
	
	/* campi */
	private TreeMap convMap = new TreeMap();
	private PacketDispatcher dispatcher = null;
	
	/**
	 * Crea una istanza di ConversationManager (ve ne pu essere solamente una all'interno di una aplicazione)
	 * @throws InstantiationRuleBrokenException se una istanza  gi stata creata
	 */	
	public ConversationManager(PacketDispatcher dispatcher) throws InstantiationRuleBrokenException{
		/* controlli */
		//if (instantiated)
		//	throw new InstantiationRuleBrokenException("Cannot create more tha one ConversationManager");
		
		//instantiated = true;
		
		this.dispatcher = dispatcher;
	}
	
	/**
	 * Recupera una conversazione
	 * @param convID l'id della converazione che si vuole ottenere
	 * @return la conversazione
	 */
	public synchronized IConversation getConversation(IConversationID convID){
		return (IConversation) convMap.get(convID.encode());
	}
	
	/**
	 * Verfica se una data conversaazione  presente nel repository
	 * @param convID l'id della conversazione di cui si vuole verificare la presenza
	 * @return true se la conversazione esiste, false altrimenti
	 */
	public synchronized boolean existsConversation(IConversationID convID){
		return convMap.containsKey(convID.encode());
	}
	
	/**
	 * Aggiunge una conversazione
	 * @param conv la conversazione
	 */
	public synchronized void addConversation(IConversation conv){
		convMap.put(conv.getConversationID().encode(), conv);
		dispatcher.addMailBox(conv.getConversationID());
	}
	
	/**
	 * Rimuove la conversazione specificata, se presente
	 * @param convID lid della conversazione da rimuovere
	 */
	public synchronized void removeConversation(IConversationID convID){
		convMap.remove(convID.encode());
		dispatcher.removeMailBox(convID);
	}
	
}
