/*
 * Created on 26-apr-2004
 */
package convFramework.traffic;

import convFramework.domain.*;
import convFramework.traffic.event.*;

/**
 * @author Lompa
 */
public class AutoAckManager {
	
	private IPacketIDFactory packetIDFactory = null;
	private OutQueue outQueue = null;
	private Node currentNode = null;
	
	/**
	 * @param packetIDFactory
	 * @param outQueue
	 */
	public AutoAckManager(IPacketIDFactory packetIDFactory, OutQueue outQueue, Node currentNode) {
		super();
		this.packetIDFactory = packetIDFactory;
		this.outQueue = outQueue;
		this.currentNode = currentNode;
	}
	


	/* (non-Javadoc)
	 * @see convFramework.traffic.event.IContentPacketArrivedListener#contentPacketArrived(convFramework.traffic.event.ContentPacketArrivedEvent)
	 */
	public void ackPacket(Packet packet) {
		if (packet.isAutoAckRequired()){
			IConversationID convID = packet.getConversationID();
			IPacketID packetID = packetIDFactory.newPacketID(currentNode);
			
			AutoAckPacket ack = new AutoAckPacket(packetID, convID);
			ack.setSender(currentNode);
			ack.setReceiver(packet.getSender());
			ack.acknowledge(packet);
			
			outQueue.insertPacket(ack);
		}
	}
}
