/*
 * Created on 17-apr-2004
 *
 */
package convFramework.domain;

import java.net.*;
import convFramework.exceptions.*;

/**
 * @author Lompa
 */
public abstract class Node {
	
	private InetAddress address = null;
	private int port = 3334;
	
	/**
	 * @param address l'indirizzo del nodo
	 * @param port la porta TCP o UDP su cui il nodo risponde
	 * @throws InvocationArgumentException in caso uno degli argomenti passati non abbia valore valido
	 */
	public Node(InetAddress address, int port) throws BadInvocationArgumentException{
		/* controlli */
		if (port <= 0 || port > 65536)
			throw new BadInvocationArgumentException("port", "port value out of bounds");
		
		/* assegnamenti */
		this.address = address;
		this.port = port;
	}
	
	/**
	 * restituisce l'indirizzo IP del nodo
	 * @return l'indirizzo
	 */
	public InetAddress getAddress(){
		return this.address;
	}
	
	/**
	 * Restituisce la orta su cui il nodo  in ascolto
	 * @return la porta
	 */
	public int getPort(){
		return this.port;
	}
	
	public abstract String getType();
	
	/**
	 * @param node
	 * @return
	 */
	public boolean isSame(Node node){
		return node.getAddress().equals(this.address) && node.getPort() == this.port;
	}

}
