/*
 * Created on 17-apr-2004
 *
 */
package convFramework.domain;

import convFramework.traffic.*;

/**
 * @author Lompa
 * Classe che rappresenta un pacchetto base per il framework; non ve istanzieta utilizzando il costruttore,
 * occorre invece usare l'apposita claffe factory (PacketFactory)
 * 
 * La classe packet pu esssere estesa per modellare i vari pacchetti utilizzati dai protocolli. Per crearli
 * occorre definire una apposita factory o estendere quella base 
 */
public class ContentPacket extends Packet{
	
	private String content = "";
	
	/**
	 * Costruttore base, da non utilizzare (va usata la classe PacketFactory)
	 * @param packetID l'id del pacchetto
	 * @param convID l'id della conversazione di cui fa parte
	 */
	public ContentPacket(IPacketID packetID, IConversationID convID){
		super(packetID, convID);
	}
	
	/**
	 * @return
	 */
	public String getType(){
		return getTypeDescription();
	}
	
	/**
	 * @return
	 */
	public static String getTypeDescription(){
		return "contentPacket";
	}
	
	/**
	 * @return Returns the content.
	 */
	public String getContent() {
		return content;
	}
	/**
	 * @param content The content to set.
	 */
	public void setContent(String content) {
		this.content = content;
	}
	
}
