/*
 * Created on 19-apr-2004
 */
package convFramework.domain;

import convFramework.exceptions.*;

/**
 * @author Lompa
 */
public class BasicPacketIDFactory implements IPacketIDFactory {
	
	/* stato di istanziazione */
	//static boolean instantiated = false;
	
	/* campi */
	int counter = 0;
	
	public BasicPacketIDFactory() throws InstantiationRuleBrokenException{
		//if (instantiated)
		//	throw new InstantiationRuleBrokenException("Cannot instantiate more than one BasicPacketIDFactory");
		
		//instantiated = true;
	}
	
	
	/* (non-Javadoc)
	 * @see convFramework.domain.IConversationIDFactory#decode(java.lang.String)
	 */
	public IPacketID decode(String encodedConvID) {
		//TODO si potrebbe controllare che l'id non sia g stato utilizzato
		return new BasicPacketID(encodedConvID);
	}
	
	/**
	 * Crea un nuovo id di conversazione
	 * @param starter il nodo che inizia la conversazione
	 * @return l'id
	 */
	public IPacketID newPacketID(Node sender){
		IPacketID packetID = new BasicPacketID("#"+sender.getAddress().getHostAddress()+"#"+sender.getPort()+"#"+counter+"#");
		counter++;
		return packetID;
	}	
}
