/*
 * Created on 17-apr-2004
 *
 */
package convFramework.domain;

import convFramework.traffic.*;

/**
 * @author Lompa
 * Classe che rappresenta un pacchetto base per il framework; non ve istanzieta utilizzando il costruttore,
 * occorre invece usare l'apposita claffe factory (PacketFactory)
 * 
 * La classe packet pu esssere estesa per modellare i vari pacchetti utilizzati dai protocolli. Per crearli
 * occorre definire una apposita factory o estendere quella base 
 */
public class AutoAckPacket extends Packet{

	/**
	 * @param packetID
	 * @param convID
	 */
	public AutoAckPacket(IPacketID packetID, IConversationID convID) {
		super(packetID, convID);
	}

	/**
	 * @return
	 */
	public String getType(){
		return getTypeDescription();
	}
	
	/**
	 * @return
	 */
	public static String getTypeDescription(){
		return "autoAckPacket";
	}


}
