/*
 * Created on 28-apr-2004
 */
package a3.traffic;

import jaCop.domain.*;
import a3.exceptions.*;
import a3.domain.*;

import convFramework.facade.*;
import convFramework.domain.*;

import jaCop.nodeStatus.*;

/**
 * @author Lompa
 */
public class A3PacketManager {
	
	/* flag di istanziazione */
	//private static boolean instantiated = false;
	
	/* campi */
	private TrafficManager trafficMan = null;
	private A3PacketTranslator translator = null;
	
	/**
	 * @param trafficMan
	 */
	public A3PacketManager(TrafficManager trafficMan){
		this.trafficMan = trafficMan;
		this.translator = new A3PacketTranslator(new A3XMLEncoder(), new A3XMLDecoder());
	}
	
	public synchronized A3Stop newA3Stop(IConversationID convID, String community){
		ContentPacket packet = trafficMan.newPacket(convID);
		A3Node sender = null;
		try { sender = new A3Node(trafficMan.getCurrentNode().getAddress(), trafficMan.getCurrentNode().getPort()); }
		catch(convFramework.exceptions.BadInvocationArgumentException e){ throw new A3Error("Invailid port for current node"); }
		return new A3Stop(community, sender, convID, packet.getPacketID());
	}
	
	public synchronized A3Structure newA3Structure(IConversationID convID, String community){
		ContentPacket packet = trafficMan.newPacket(convID);
		A3Node sender = null;
		try { sender = new A3Node(trafficMan.getCurrentNode().getAddress(), trafficMan.getCurrentNode().getPort()); }
		catch(convFramework.exceptions.BadInvocationArgumentException e){ throw new A3Error("Invailid port for current node"); }
		return new A3Structure(community, sender, convID, packet.getPacketID());
	}
	
	public synchronized A3StructureRequest newA3StructureRequest(IConversationID convID, String community){
		ContentPacket packet = trafficMan.newPacket(convID);
		A3Node sender = null;
		try { sender = new A3Node(trafficMan.getCurrentNode().getAddress(), trafficMan.getCurrentNode().getPort()); }
		catch(convFramework.exceptions.BadInvocationArgumentException e){ throw new A3Error("Invailid port for current node"); }
		return new A3StructureRequest(community, sender, convID, packet.getPacketID());
	}
	
	public synchronized void send(A3Packet packet) throws TranslationException{
		trafficMan.sendPacket(translator.translate(packet));
	}
	
	public A3Packet receive(IConversationID convID) throws TranslationException, InterruptedException{
		ContentPacket packet = trafficMan.receivePacket(convID);
		synchronized(this){
			return translator.translate(packet);
		}
	}
	
	public synchronized IConversation newConversation(){
		return this.trafficMan.newConversation();
	}
	
	public synchronized A3Node getCurrentNode(){
		try {
			return new A3Node(trafficMan.getCurrentNode().getAddress(), trafficMan.getCurrentNode().getPort());
		}
		catch(convFramework.exceptions.BadInvocationArgumentException e){
			throw new A3Error(e.getMessage());
		}
	}
	
	/**
	 * @param packet
	 * @return
	 * @throws TranslationException
	 */
	public synchronized A3Packet translate(ContentPacket packet)
			throws TranslationException {
		return translator.translate(packet);
	}
}
