/*
 * Created on 4-mag-2004
 */
package a3.protocol;

import convFramework.domain.*;

import java.util.*;

/**
 * @author Lompa
 */
public class ConversationGraveyard {
	
	/* campi */
	private Vector graveyard = null;
	private int capacity = -1;
	
	/**
	 * Crea un cimitero di conversazioni con capacit limitata
	 * @param capacity
	 */
	public ConversationGraveyard(int capacity) {
		this.capacity = capacity;
		this.graveyard = new Vector(capacity);
	}
	
	/**
	 * Crea un cimitero di conversazioni con capacit illimitata
	 * @param capacity
	 */
	public ConversationGraveyard() {
		this.graveyard = new Vector(50);
	}
	
	/**
	 * @param conv
	 * @return
	 */
	public synchronized boolean isDead(IConversationID convID){
		return graveyard.contains(convID);
	}
	
	/**
	 * @param conv
	 */
	public synchronized void bury(IConversationID convID){
		if (capacity != -1 && graveyard.size() == capacity){
			graveyard.remove(0);
		}
		graveyard.add(convID);
	}

}
