/*
 * Created on 25-giu-2004
 */
package a3.protocol;

import a3.domain.A3Node;
import a3.event.IStructureSoundedListener;
import a3.traffic.*;

/**
 * @author Lompa
 */
public class A3Manager {
	
	/* campi */
	private A3EventListenerManager listenerMan = null;
	private ProtocolTrigger trigger = null;
	private A3PacketManager packetMan = null;
	
	/**
	 * @param listenerMan
	 * @param trigger
	 */
	public A3Manager(A3EventListenerManager listenerMan, ProtocolTrigger trigger, A3PacketManager packetMan) {
		this.listenerMan = listenerMan;
		this.trigger = trigger;
		this.packetMan = packetMan;
	}
	
	/**
	 * @param listener
	 */
	public void addStructureSoundedListener(IStructureSoundedListener listener) {
		listenerMan.addStructureSoundedListener(listener);
	}
	/**
	 * @return
	 */
	public IStructureSoundedListener[] getStructureSoundedListeners() {
		return listenerMan.getStructureSoundedListeners();
	}
	/**
	 * @param listener
	 */
	public void removeStructureSoundedListener(
			IStructureSoundedListener listener) {
		listenerMan.removeStructureSoundedListener(listener);
	}
	/**
	 * @param community
	 * @param servant
	 */
	public void soundCommunity(String community) {
		trigger.soundCommunity(community);
	}
	/**
	 * @param community
	 */
	public void stopSoundCommunity() {
		trigger.stopSoundCommunity();
	}
	
	
	/**
	 * @return
	 */
	public A3Node getCurrentNode() {
		return packetMan.getCurrentNode();
	}
}
