/*
 * Created on 20-apr-2004
 */
package a3.protocol;

import java.util.*;

import a3.event.*;
import a3.exceptions.*;

/**
 * Gestore cui occorre registrare i listener degli eventi legati all'arrivo di pacchetti,
 * perch possnao esserne notificati. Ne pu esistere una sola istanza. La classe  predisposta per supportare
 * accessi concorrenti
 * @author Lompa
 */
public class A3EventListenerManager {
	
	/* flag di istanziazione */
	//private static boolean instantiated = false;
	
	/* campi */
	private Vector structureSoundedListeners = new Vector();
	
	/**
	 * Crea un istanza di A3EventListenerManager
	 * @throws InstantiationRuleBrokenException se la classe  gi stata istanziata
	 */
	public A3EventListenerManager() throws InstantiationRuleBrokenException{
		//if (instantiated)
		//	throw new InstantiationRuleBrokenException("Cannot create more than one A3EventListenerManager");
		
		//instantiated = true;
	}
	
	public synchronized void addStructureSoundedListener(IStructureSoundedListener listener){
		this.structureSoundedListeners.add(listener);
	}
	
	public synchronized void removeStructureSoundedListener(IStructureSoundedListener listener){
		this.structureSoundedListeners.remove(listener);
	}
	
	public synchronized IStructureSoundedListener[] getStructureSoundedListeners(){
		IStructureSoundedListener[] listeners = new IStructureSoundedListener[this.structureSoundedListeners.size()];
		this.structureSoundedListeners.toArray(listeners);
		return listeners;
	}
	
}
