/*
 * Created on 26-apr-2004
 */
package a3.domain;

import convFramework.domain.*;
import jaCop.domain.*;

/**
 * Un pacchetto per il protocollo COP
 * @author Lompa
 */
public class A3Packet {
	
	private String community = null;
	private A3Node sender = null;
	private A3Node receiver = null;
	private IConversationID convID = null;
	private boolean hasFollowing = false;
	private IPacketID previousPacket = null;
	private IPacketID packetID = null;
	
	/**
	 * @param community
	 * @param sender
	 * @param convID
	 * @param packetID
	 */
	public A3Packet(String community, A3Node sender, IConversationID convID, IPacketID packetID) {
		this.community = community;
		this.sender = sender;
		this.convID = convID;
		this.packetID = packetID;
	}	
	
	/**
	 * @return Returns the isSequence.
	 */
	public boolean isSequence() {
		return this.hasFollowing || this.previousPacket != null;
	}
	/**
	 * @return Returns the servant.
	 */
	public A3Node getReceiver() {
		return receiver;
	}
	/**
	 * @param servant The servant to set.
	 */
	public void setReceiver(A3Node receiver) {
		this.receiver = receiver;
	}
	/**
	 * @return Returns the community.
	 */
	public String getCommunity() {
		return community;
	}
	/**
	 * @return Returns the convID.
	 */
	public IConversationID getConvID() {
		return convID;
	}
	/**
	 * @return Returns the packetID.
	 */
	public IPacketID getPacketID() {
		return packetID;
	}
	/**
	 * @return Returns the sender.
	 */
	public A3Node getSender() {
		return sender;
	}
	
	/**
	 * @param packet
	 */
	public void follows(IPacketID packetID){
		this.previousPacket = packetID;
	}
	/**
	 * @return Returns the previousPacket.
	 */
	public IPacketID getPreviousPacket() {
		return previousPacket;
	}
	/**
	 * @return
	 */
	public boolean hasFollowing(){
		return this.hasFollowing;
	}
	/**
	 * @param value
	 */
	public void setFollowed(boolean value){
		this.hasFollowing = value;
	}
	/**
	 * @return
	 */
	public static String getTypeDescription(){
		return "A3Packet";
	}
	/**
	 * @return
	 */
	public String getType(){
		return getTypeDescription();
	}
}
