import SOMA.agent.*;
import SOMA.gui.*;
import SOMA.utility.*;


/**
 * The minimal windowed agent - a mobile agent controlled by a window
 * built up using the SOMA GUI facilities.
 *
 * @author	Giulio Piancastelli
 * @version	1.0 - Monday 18th February, 2002
 */
public class WinSkeletonAgent extends Agent {
	
	/* Transient members */
	
	// The agent's output window
	private transient OutputFrame2 window;
	// Wait on the semaphore before exiting - to synchronize the main thread (waiting) with
	// actions from the menu and buttons
	private transient WaitAndTimeout exitSemaphore;
	
	public void run() {
		
		agentSystem.getOut().println("Agent [" + getID() + "] running...");
		buildWindow(); // create the agent's window
		
		exitSemaphore = new WaitAndTimeout(0, "<EXIT>", window.out);
		startMethod();
		
	}
	
	public void startMethod() {
		
		agentSystem.getOut().println("Agent [" + getID() + "] executing startMethod...");
		
		exitSemaphore.Wait(); // waiting here...
		// restarting with Exit, Go or Idle commands
		window.dispose();
		agentSystem.getOut().println("Agent [" + getID() + "] exiting from main thread...");
		
	}
	
	private void buildWindow() {
		
		window = new OutputFrame2("Agent [" + getID() + "]", WinSkeletonAgent.class.getName());
		
		// what to do on exit
		window.onExitCommand = new OutputFrame2.Listener() {
			
			public void run() {
				
				// show this message in the agent window when exiting
				window.out.println("Agent [" + getID() + "] exiting...");
				exitSemaphore.Done();
			
			}
			
		};
		
		window.pack();
		window.setVisible(true);
		
	}
	
} // end WinAgent
