import SOMA.agent.*;
import SOMA.naming.*;

import java.util.*;

/**
 * An example of a lurker agent coordinating with a base agent thanks to
 * the use of shared objects.
 *
 * @author	Giulio Piancastelli
 * @version	1.0 - Wednesday 13th February, 2002
 */
public class SObjLurkerAgent extends Agent {
	
	private PlaceID myHome; // the PlaceID the agent come from
	
	// myIndex really indicates the particular shared object property of the lurker agent,
	// i.e. the one and only object a single lurker agent will modify
	private int myIndex;
	private String manipulation = "";
	
	public void putArgument(Object obj) {
		
		Vector v = (Vector) obj;
		myHome = (PlaceID) v.get(0);
		Integer temp = (Integer) v.get(1);
		myIndex = temp.intValue(); // the agent destination place's index in the shared objects table
		
	}
	
	public void run() {
		
		try {
			go((PlaceID) agentSystem.sharedObjects.get(myIndex), "buildString");
		} catch (CantGoException cge) {
			cge.printStackTrace();
		}
		
	}
	
	/**
	 * Builds the String which will substitute the destination PlaceID entry in the
	 * shared objects table.
	 */
	public void buildString() {
		// Get children domains
		if (agentSystem.getPlaceID().isDomain()) {		
			Vector children = agentSystem.getEnvironment().domainNameService.getChildrenDNS(); // a Vector of PlaceIDs
			for (int index = children.size() - 1; index >= 0; index--) {
				PlaceID place = (PlaceID) children.get(index);
				manipulation += place.toString();
			}
		}
		// Get places in this domain
		Vector places = new Vector(Arrays.asList(agentSystem.getPlaces()));
		places.remove(agentSystem.getPlaceID());
		for (int index = places.size() - 1; index >= 0; index--) {
			PlaceID place = (PlaceID) places.get(index);
			manipulation += " " + place.toString();
		}
		
		try {
			go(myHome, "manipulate");
		} catch (CantGoException cge) {
			cge.printStackTrace();
		}
	
	}
	
	public void manipulate() {
		// Substitute the old object (a PlaceID) with the String previously built
		agentSystem.sharedObjects.remove(myIndex);
		agentSystem.sharedObjects.put(myIndex, manipulation);
		// Print all the shared objects except the one just modified
		agentSystem.getOut().println("---" + getID() + "---" + myIndex + "---\n");
		for (int index = agentSystem.sharedObjects.size() - 1; index >= 0; index--)
			if (index != myIndex)
				agentSystem.getOut().println(agentSystem.sharedObjects.get(index).toString());
	}
	
} // end SObjLurkerAgent
