import SOMA.agent.*;
import SOMA.naming.*;

import java.util.*;

/**
 * An example of a base agent using shared objects to coordinate its work
 * with other lurker agents.
 * Note that the base agent does not die, but waits for the lurker agent(s)
 * to return, and must be terminated manually, since it uses the idle() method
 * to suspend itself.
 *
 * @author	Giulio Piancastelli
 * @version	1.0 - Wednesday 13th February, 2002
 */
public class SObjBaseAgent extends Agent {
	
	public void run() {
		
		Vector placesToVisit = new Vector();
		PlaceID home = agentSystem.getPlaceID();
		SOMA.Environment env = agentSystem.getEnvironment();
		
		if (home.isDomain()) {
			// Get children domains
			Vector children = env.domainNameService.getChildrenDNS(); // a Vector of PlaceIDs
			for (int index = children.size() - 1; index >= 0; index--) {
				PlaceID place = (PlaceID) children.get(index);
				// update the list of places to visit
				placesToVisit.add(place);
			}
			// Get places in this domain
			Vector places = new Vector(Arrays.asList(agentSystem.getPlaces()));
			places.remove(home);
			for (int index = places.size() - 1; index >= 0; index--) {
				PlaceID place = (PlaceID) places.get(index);
				// update the list of places to visit
				placesToVisit.add(place);
			}
		}
		
		// Initialize the shared objects relative to all children domains and places
		for (int index = placesToVisit.size() - 1; index >= 0; index--) {
			PlaceID place = (PlaceID) placesToVisit.get(index);
			agentSystem.sharedObjects.put(index, place);
		}
		
		// Create lurkers which will move on first level domains and places, access shared
		// objects and somehow manipulate them
		for (int index = placesToVisit.size() - 1; index >= 0; index--) {
			Vector v = new Vector();
			v.add(home);
			v.add(new Integer(index));
			AgentWorker lurker = env.agentManager.createAgent("SObjLurkerAgent", v, false, true);
			try {
				lurker.start();
			} catch (AgentWorker.AgentWorkerException awe) {
				awe.printStackTrace();
			}
		}
		
		idle("printSharedObjects"); // wait
	}
	
	public void printSharedObjects() {
		
		for (int index = agentSystem.sharedObjects.size() - 1; index >= 0; index--)
			agentSystem.getOut().println(agentSystem.sharedObjects.get(index).toString());
		
	}
	
} // end SObjBaseAgent
