import SOMA.agent.*;
import SOMA.naming.*;
import SOMA.naming.domain.*;

import java.util.*;

/**
 * A try to interact with the Environment and the Domain Name Service,
 * and to move an agent around the system.
 *
 * @author	Giulio Piancastelli
 * @version	1.0 - Monday 11th February, 2002
 */
public class RegionTourAgent extends Agent {
	
	// Serializable members
	private Vector placesToVisit = new Vector();
	// private int visits = -1; // initialitation value
	
	public void run() {
		
		// visits++;
		list();
		
		// Move agent on the other domains or places just listed
		if (placesToVisit.size() > 0) {
			PlaceID placeToGo = (PlaceID) placesToVisit.get(0);
			placesToVisit.remove(placeToGo);
			try {
				go(placeToGo, "run");
			} catch (CantGoException e) {
				e.printStackTrace();
			}
		} else
			agentSystem.getOut().println("Tour finished!");
	}
	
	public void list() {
		
		PlaceID home = agentSystem.getPlaceID();
		
		if (home.isDomain()) {
			// Get children domains
			DomainNameService dns = agentSystem.getEnvironment().domainNameService;
			Vector children = dns.getChildrenDNS(); // a Vector of PlaceIDs
			for (int index = children.size() - 1; index >= 0; index--) {
				PlaceID place = (PlaceID) children.get(index);
				placesToVisit.add(place);
			}
			// Get places in this domain
			Vector places = new Vector(Arrays.asList(agentSystem.getPlaces()));
			places.remove(home);
			for (int index = places.size() - 1; index >= 0; index--) {
				PlaceID place = (PlaceID) places.get(index);
				placesToVisit.add(place);
			}
		}
		
		// Print results
		for (int index = placesToVisit.size() - 1; index >= 0; index--) {
			PlaceID place = (PlaceID) placesToVisit.get(index);
			agentSystem.getOut().println(place);
		}
	}

} // end RegionTourAgent
