import SOMA.agent.*;

import java.util.*;

public class MailboxTry30 extends Agent {
	
	private byte numMessage = 0;
	private byte numAgents = 4;
	
	public void run() {
		
		SOMA.Environment env = agentSystem.getEnvironment();
		// set the shared object for MailboxTry31 agents
		Vector children = env.domainNameService.getChildrenDNS();
		agentSystem.sharedObjects.put(0, children.get(0));
		agentSystem.sharedObjects.put(1, children.get(1));
		agentSystem.sharedObjects.put(2, children.get(2));
		agentSystem.sharedObjects.put(3, children.get(3));
		
		Vector data = new Vector();
		data.add(agentSystem.getPlaceID());
		data.add(getID()); // the base MailboxTry30 agent ID
		data.add(new Integer(0));
		AgentWorker firstLurker = env.agentManager.createAgent("MailboxTry31", data, false, true);
		data = new Vector();
		data.add(agentSystem.getPlaceID());
		data.add(getID()); // the base MailboxTry30 agent ID
		data.add(new Integer(1));
		AgentWorker secondLurker = env.agentManager.createAgent("MailboxTry31", data, false, true);
		data = new Vector();
		data.add(agentSystem.getPlaceID());
		data.add(getID()); // the base MailboxTry30 agent ID
		data.add(new Integer(2));
		AgentWorker thirdLurker = env.agentManager.createAgent("MailboxTry31", data, false, true);
		data = new Vector();
		data.add(agentSystem.getPlaceID());
		data.add(getID()); // the base MailboxTry30 agent ID
		data.add(new Integer(3));
		AgentWorker fourthLurker = env.agentManager.createAgent("MailboxTry31", data, false, true);
		
		try {
			firstLurker.start();
			secondLurker.start();
			thirdLurker.start();
			fourthLurker.start();
		} catch (AgentWorker.AgentWorkerException awe) {
			awe.printStackTrace();
		}
		
		// if the agent is not traceable, there is no mailbox
		if (mailbox != null)
			mailbox.mailListener = new Mailbox.MailListener() {
				
				public void run() {
				
					Message mex = mailbox.getMessage();
					agentSystem.getOut().println("Message received by " + mex.from);
					if (mex.message.toString().equals("lurker_agent_done"))
						numMessage++;
					agentSystem.getOut().println("" + numMessage + " message(s) arrived");
				
				}
				
			};
		agentSystem.getOut().println("" + getID() + ": I'm going idle...");
		idle("idleCycle");
		
	}
	
	public void idleCycle() {
		
		if (numMessage != numAgents)
			idle("idleCycle");
		else
			printSharedObjects();
			
	}
	
	public void printSharedObjects() {
		
		for (int index = agentSystem.sharedObjects.size() - 1; index >= 0; index--)
			agentSystem.getOut().println(agentSystem.sharedObjects.get(index).toString());
		
	}
	
} // end MailboxTry30
