import SOMA.agent.*;
import SOMA.naming.*;

import java.util.*;

public class MailboxTry01 extends Agent {
	
	private PlaceID home;
	private AgentID parent;
	private String manipulation = "";
	
	public void putArgument(Object obj) {
		
		Vector temp = (Vector) obj;
		home = (PlaceID) temp.get(0);
		parent = (AgentID) temp.get(1);
		
	}
	
	public void run() {
		
		try {
			go((PlaceID) agentSystem.sharedObjects.get(0), "buildString");
		} catch (CantGoException cge) {
			cge.printStackTrace();
		}
		
	}
	
	public void buildString() {
		
		Vector places = new Vector(Arrays.asList(agentSystem.getPlaces()));
		places.remove(agentSystem.getPlaceID());
		for (int index = places.size() - 1; index >= 0; index--) {
			PlaceID place = (PlaceID) places.get(index);
			manipulation += " " + place.toString();
		}
		
		try {
			go(home, "atHome");
		} catch (CantGoException cge) {
			cge.printStackTrace();
		}
	
	}
	
	public void atHome() {
		
		// Substitute the old object (a PlaceID) with the String previously built
		agentSystem.sharedObjects.remove(0);
		agentSystem.sharedObjects.put(0, manipulation);
		// the agent has done, and notifies it to its parent
		Message mex = new Message("lurker_agent_done", getID(), parent);
		agentSystem.sendMessage(mex);
	
	}
	
} // end MailboxTry01
