import SOMA.agent.*;

import java.util.*;

public class MailboxTry00 extends Agent {
	
	private byte numMessage = 0;
	
	public void run() {
		
		SOMA.Environment env = agentSystem.getEnvironment();
		// set the shared object for MailboxTry01 agent
		agentSystem.sharedObjects.put(0, env.domainNameService.getChildrenDNS().get(0));
		
		Vector data = new Vector();
		data.add(agentSystem.getPlaceID());
		data.add(getID()); // the base MailboxTry00 agent ID
		AgentWorker lurker = env.agentManager.createAgent("MailboxTry01", data, false, true);
		
		try {
			lurker.start();
		} catch (AgentWorker.AgentWorkerException awe) {
			awe.printStackTrace();
		}
		
		// if the agent is not traceable, there is no mailbox
		if (mailbox != null)
			mailbox.mailListener = new Mailbox.MailListener() {
				
				public void run() {
				
					Message mex = mailbox.getMessage();
					agentSystem.getOut().println("Message received by " + mex.from);
					if (mex.message.toString().equals("lurker_agent_done"))
						numMessage++;
					agentSystem.getOut().println("" + numMessage + " message(s) arrived");
				
				}
				
			};
		idle("printSharedObjects");
		
	}
	
	public void printSharedObjects() {
		
		for (int index = agentSystem.sharedObjects.size() - 1; index >= 0; index--)
			agentSystem.getOut().println(agentSystem.sharedObjects.get(index).toString());
		
	}
	
} // end MailboxTry00
