import SOMA.agent.*;
import SOMA.naming.*;

import java.util.*;

/**
 * An example of a lurker agent coordinating with a base agent thanks to
 * the use of a mailbox.
 *
 * @author	Giulio Piancastelli
 * @version	0.1 - Wednesday 13th February, 2002
 */
public class MailboxLurkerAgent2 extends Agent {
	
	private PlaceID myHome; // the PlaceID the agent come from
	
	// myIndex really indicates the particular shared object property of the lurker agent,
	// i.e. the one and only object a single lurker agent will modify
	private int myIndex;
	private AgentID parent;
	private String manipulation = "";
	
	public void putArgument(Object obj) {
		
		Vector v = (Vector) obj;
		myHome = (PlaceID) v.get(0);
		Integer temp = (Integer) v.get(1);
		myIndex = temp.intValue(); // the agent destination place's index in the shared objects table
		parent = (AgentID) v.get(2);
		
	}
	
	public void run() {
		
		try {
			go((PlaceID) agentSystem.sharedObjects.get(myIndex), "buildString");
		} catch (CantGoException cge) {
			cge.printStackTrace();
		}
		
	}
	
	/**
	 * Builds the String which will substitute the destination PlaceID entry in the
	 * shared objects table.
	 */
	public void buildString() {
		// Get children domains
		if (agentSystem.getPlaceID().isDomain()) {		
			Vector children = agentSystem.getEnvironment().domainNameService.getChildrenDNS(); // a Vector of PlaceIDs
			for (int index = children.size() - 1; index >= 0; index--) {
				PlaceID place = (PlaceID) children.get(index);
				manipulation += place.toString();
			}
		}
		// Get places in this domain
		Vector places = new Vector(Arrays.asList(agentSystem.getPlaces()));
		places.remove(agentSystem.getPlaceID());
		for (int index = places.size() - 1; index >= 0; index--) {
			PlaceID place = (PlaceID) places.get(index);
			manipulation += " " + place.toString();
		}
		
		// Build a huge vector - make them being late!
		Vector v = new Vector();
		for (int i = 0; i < 10000; i++)
			v.add(new Integer(i));
		
		try {
			go(myHome, "manipulate");
		} catch (CantGoException cge) {
			cge.printStackTrace();
		}
	
	}
	
	public void manipulate() {
		// Substitute the old object (a PlaceID) with the String previously built
		agentSystem.sharedObjects.remove(myIndex);
		agentSystem.sharedObjects.put(myIndex, manipulation);
		// the agent has done, and notifies it to its parent
		Message mex = new Message("lurker_agent_done", getID(), parent);
		agentSystem.sendMessage(mex);
	}
	
} // end MailboxLurkerAgent2
