import SOMA.agent.*;
import SOMA.naming.*;


import java.util.*;

/**
 * An example of a base agent using its mailbox to coordinate its work
 * with other lurker agents.
 *
 * @author	Giulio Piancastelli
 * @version	0.1 - Wednesday 13th February, 2002
 */
public class MailboxBaseAgent2 extends Agent {
	
	private int numAgents = 0;
	private int numMessage = 0;
	
	public void run() {
		
		Vector placesToVisit = new Vector();
		PlaceID home = agentSystem.getPlaceID();
		SOMA.Environment env = agentSystem.getEnvironment();
		
		if (home.isDomain()) {
			// Get children domains
			Vector children = env.domainNameService.getChildrenDNS(); // a Vector of PlaceIDs
			for (int index = children.size() - 1; index >= 0; index--) {
				PlaceID place = (PlaceID) children.get(index);
				// update the list of places to visit
				placesToVisit.add(place);
			}
			// Get places in this domain
			Vector places = new Vector(Arrays.asList(agentSystem.getPlaces()));
			places.remove(home);
			for (int index = places.size() - 1; index >= 0; index--) {
				PlaceID place = (PlaceID) places.get(index);
				// update the list of places to visit
				placesToVisit.add(place);
			}
		}
		
		// Initialize the shared objects relative to all children domains and places
		for (int index = placesToVisit.size() - 1; index >= 0; index--) {
			PlaceID place = (PlaceID) placesToVisit.get(index);
			agentSystem.sharedObjects.put(index, place);
		}
		
		// Create lurkers which will move on first level domains and places, access shared
		// objects and somehow manipulate them
		for (int index = placesToVisit.size() - 1; index >= 0; index--) {
			Vector v = new Vector();
			v.add(home);
			v.add(new Integer(index));
			v.add(getID()); // the base agent ID
			AgentWorker lurker = env.agentManager.createAgent("MailboxLurkerAgent2", v, false, true);
			try {
				lurker.start();
			} catch (AgentWorker.AgentWorkerException awe) {
				awe.printStackTrace();
			}
			numAgents++;
		}
		
		// if the agent is not traceable, there is no mailbox
		if (mailbox != null)
			mailbox.mailListener = new Mailbox.MailListener() {
				
				public void run() {
				
					Message mex = mailbox.getMessage();
					agentSystem.getOut().println("Message received by " + mex.from);
					if (mex.message.toString().equals("lurker_agent_done"))
						numMessage++;
					agentSystem.getOut().println("" + numMessage + " message(s) arrived");
				
				}
				
			};
		agentSystem.getOut().println("" + getID() + ": I'm going idle...");
		idle("idleCycle"); // wait
	}
	
	public void idleCycle() {
		
		if (numMessage != numAgents)
			idle("idleCycle");
		else
			printSharedObjects();
			
	}
	
	public void printSharedObjects() {
		
		for (int index = agentSystem.sharedObjects.size() - 1; index >= 0; index--)
			agentSystem.getOut().println(agentSystem.sharedObjects.get(index).toString());
		
	}
	
} // end MailboxBaseAgent2
