import SOMA.agent.*;
import SOMA.naming.*;

/**
 * Coupled with BaseTryAgent, this agent realizes a first try to create and
 * move new agents from an initial place.
 *
 * @author	Giulio Piancastelli
 * @version	0.1 - Wednesday 13th February, 2002
 */
public class LurkerTryAgent extends Agent {
	
	// Serializable fields
	private PlaceID myHome; // the place where the lurker was created
	private PlaceID myNextPlace; // the place where the lurker was said to go
	
	public void putArgument(Object obj) {
		
		// the object is a Vector
		java.util.Vector v = (java.util.Vector) obj;
		myHome = (PlaceID) v.get(0);
		myNextPlace = (PlaceID) v.get(1);
		
	}
	
	public void run() {
		
		try {
			go(myNextPlace, "greetings");
		} catch (CantGoException cge) {
			cge.printStackTrace();
		}
		
	}
	
	public void greetings() {
		
		agentSystem.getOut().println("I come from " + myHome + "- I was said to go to " + myNextPlace + " and I am now in " + agentSystem.getPlaceID());
	
	}
	
} // end LurkerTryAgent
