import java.util.*;
import SOMA.agent.*;
import SOMA.naming.*;

/**
* Agente di test
* 
* @author Alessandro Ghigi
*/

public class HelloAgent extends Agent {
	
	private Vector places;
	private Vector domains;
	private boolean last = false;
	
	public void run() {
		try {
			Thread.sleep(40000);
		}
		catch(Exception e) {
			e.printStackTrace();
		}
		if(this.places == null) this.places = new Vector();
		if(this.domains == null) this.domains = new Vector();
		PlaceID place = this.agentSystem.getPlaceID();
		this.agentSystem.getOut().println("Hello, I'm at " + place);
		if(place.isDomain() && !this.last) {
			// Aggiungo i domini del DNS, se non  stato gi fatto
			if(this.domains.size() == 0) {
				this.agentSystem.getOut().println("I'm in a Default Place...looking for all the other domains...");
				PlaceID[] arr_domains = this.agentSystem.getDomains();
				for(int i=0;i<arr_domains.length;i++) {
					PlaceID temp = arr_domains[i];
					if(!this.agentSystem.getPlaceID().equals(temp)) {
						this.domains.add(temp);
						this.agentSystem.getOut().println("Added new domain to visit: " + temp.toString());
					}
				}
			}
			this.agentSystem.getOut().println("I'm in a Default Place...looking for all the places of the Domain...");
			PlaceID[] arr_places = this.agentSystem.getPlaces();
			// Aggiungo gli eventuali places
			for(int i=0;i<arr_places.length;i++) {
				PlaceID temp = arr_places[i];
				if(!temp.isDomain()) {
					this.places.add(temp);
					this.agentSystem.getOut().println("Added new place to visit: " + temp.toString());
				}
			}
			whereToGo();
		}
		else whereToGo();
	}
	
	public void whereToGo() {
		if(this.places.size() != 0) {
			try {
				PlaceID toGo = (PlaceID)places.get(0);
				this.places.remove(toGo);
				this.agentSystem.getOut().println("Migrating to " + toGo.toString());
				go(toGo,"run");
			}
			catch(Exception e) {
				e.printStackTrace();
			}
		}
		else {
			if(this.domains.size() != 0) {
				this.agentSystem.getOut().println("I've finished to visit all the places of this domain...migrating to a new Domain");
				try {
					PlaceID toGo = (PlaceID)domains.get(0);
					this.domains.remove(toGo);
					if(this.domains.size() == 0) this.last = true;
					this.agentSystem.getOut().println("Migrating to " + toGo.toString());
					go(toGo,"run");
				}
				catch(Exception e) {
					e.printStackTrace();
				}
			}
			else this.agentSystem.getOut().println("I've finished to visit all the domains...bye!");
		}
	}
	
}
