import SOMA.agent.*;
import SOMA.naming.*;
import SOMA.naming.domain.*;

import java.util.*;

/**
 * Another try to interact with the Environment and
 * the Domain Name Service.
 *
 * @author	Giulio Piancastelli
 * @version	0.1 - Sunday 10th February, 2002
 */
public class EnvAgent extends Agent {
	
	private Vector placesToVisit = new Vector();
	
	public void run() {
		
		PlaceID home = agentSystem.getPlaceID();
		
		if (home.isDomain()) {
			// Get children domains
			DomainNameService dns = agentSystem.getEnvironment().domainNameService;
			Vector children = dns.getChildrenDNS(); // a Vector of PlaceIDs
			for (int index = children.size() - 1; index >= 0; index--) {
				PlaceID place = (PlaceID) children.get(index);
				placesToVisit.add(place);
			}
			// Get places in this domain
			Vector places = new Vector(Arrays.asList(agentSystem.getPlaces()));
			places.remove(home);
			for (int index = places.size() - 1; index >= 0; index--) {
				PlaceID place = (PlaceID) places.get(index);
				placesToVisit.add(place);
			}
		} else {
			placesToVisit.add(home);
		}
		// Print results
		for (int index = placesToVisit.size() - 1; index >= 0; index--) {
			PlaceID place = (PlaceID) placesToVisit.get(index);
			agentSystem.getOut().println(place);
		}	
		
	}
	
} // end RegionTourAgent
