import SOMA.agent.*;
import SOMA.naming.*;

import java.util.*;

/**
 * This class represents the base agent, and it creates LurkerTryAgent(s) in order
 * to explore the first-level domains and places. Note that the base agent is fixed
 * (i.e. it does not move itself around the domains).
 *
 * @author	Giulio Piancastelli
 * @version	0.1 - Wednesday 13th February, 2002
 */
public class BaseTryAgent extends Agent {
	
	public void run() {
		
		Vector placesToVisit = new Vector();
		PlaceID home = agentSystem.getPlaceID();
		SOMA.Environment env = agentSystem.getEnvironment();
		
		if (home.isDomain()) {
			// Get children domains
			Vector children = env.domainNameService.getChildrenDNS(); // a Vector of PlaceIDs
			for (int index = children.size() - 1; index >= 0; index--) {
				PlaceID place = (PlaceID) children.get(index);
				// update the list of places to visit
				placesToVisit.add(place);
			}
			// Get places in this domain
			Vector places = new Vector(Arrays.asList(agentSystem.getPlaces()));
			places.remove(home);
			for (int index = places.size() - 1; index >= 0; index--) {
				PlaceID place = (PlaceID) places.get(index);
				// update the list of places to visit
				placesToVisit.add(place);
			}
		}
		
		for (int index = placesToVisit.size() - 1; index >= 0; index--) {
			PlaceID placeToGo = (PlaceID) placesToVisit.get(index);
			Vector v = new Vector();
			v.add(home);
			v.add(placeToGo);
			AgentWorker lurker = env.agentManager.createAgent("LurkerTryAgent", v, false, true);
			if (lurker != null)
				try {
					lurker.start();
				} catch (AgentWorker.AgentWorkerException awe) {
					awe.printStackTrace();
				}
		}
	}
} // end BaseTryAgent
