package SOMA.utility;

import java.security.*;
import java.io.*;


public class PrintProtectionDomain implements PrivilegedAction
{
  private Object object;
  private PrintStream out;

  public PrintProtectionDomain( Object object, PrintStream out )
  {
    this.object = object;
    this.out = out;
  }

  public PrintProtectionDomain( Object object )
  {
    this.object = object;
    this.out = System.out;
  }

  public Object run()
  {
    out.println( "Object: " + object );

    Class objectClass = object.getClass();
    out.println( "Class: " + objectClass );

    try
    {
      ProtectionDomain protectionDomain = objectClass.getProtectionDomain();
      out.println( "Protection Domain: " + protectionDomain );

    // CodeSource codeSource = protectionDomain.getCodeSource();
    // out.println( "Code Source: " + codeSource );

    // PermissionCollection permissionCollection = protectionDomain.getPermissions();
    // out.println( "Permission Collection: " + permissionCollection );
    }
    catch( SecurityException e )
    {
      e.printStackTrace( out );
    }

    return null;
  }

  public static void Do( Object object, PrintStream out )
  {
    AccessController.doPrivileged( new PrintProtectionDomain( object, out ) );
  }

  public static void Do( Object object )
  {
    AccessController.doPrivileged( new PrintProtectionDomain( object ) );
  }

}
