package SOMA.utility;

import java.util.*;

/** Classe che permette di effettuare misure di tempi.
*
* @author Livio Profiri
*/
public class Chronometer implements java.io.Serializable
{
  /** Descrizione del cronometro.
  * @serial*/
  public String Description;
  /** Istante di avvio.
  * @serial*/
  public long StartTime = 0;
  /** Istante di arresto.
  * @serial*/
  public long StopTime = 0;

  /** Cronometro vuoto. */
  public Chronometer()
  {
    this( "Chronometer" );
  }

  /** Cronometro con descrizione. */
  public Chronometer( String Description )
  {
    this.Description = Description;
  }

  /** Cronometro con descrizione, ma con gli stessi valori di un secondo cronometro. */
  public Chronometer( String Description, Chronometer other )
  {
    this.Description = Description;
    StartTime = other.StartTime;
    StopTime = other.StopTime;
  }

  /** Avvia il cronometro. */
  public void Start()
  {
    StartTime = System.currentTimeMillis();
    StopTime = 0;
  }

  /** Arresta il cronometro. */
  public void Stop()
  {
    StopTime = System.currentTimeMillis();
  }

  /** Descrizione completa dello stato. */
  public String toString()
  {
    if( StartTime == 0 )
      return Description + "[ uninitialized ]";
    if( StartTime != 0 && StopTime == 0 )
      return Description + "[Start: " + (new Date( StartTime )).toString() + " = " + StartTime +"]";
    else
      return Description + "[Start: " + (new Date( StartTime )).toString() + " = " + StartTime + ",  Stop: " + (StopTime - StartTime) + " ms]";
  }
}