package SOMA.telnet;

import java.io.*;
import java.util.*;

public class MultiOutputStream extends OutputStream
{
  public LinkedList outs = new LinkedList();

  public synchronized OutputStream getFirst()
  {
    return (OutputStream)outs.getFirst();
  }

  public synchronized OutputStream setFirst( OutputStream out )
  {
    return (OutputStream)outs.set( 0, out );
  }

  public synchronized boolean add( OutputStream out )
  {
    return outs.add( out );
  }

  public synchronized boolean remove( OutputStream out )
  {
    return outs.remove( out );
  }

  public void write(int b)
  {
    Iterator i = outs.iterator();

    while( i.hasNext() )
    {
      OutputStream out = (OutputStream)i.next();

      try
      {
        out.write( b );
        out.flush();
      }
      catch( IOException e )
      {
        i.remove();
      }
    }
  }

  public void write(byte[] b)
  {
    Iterator i = outs.iterator();

    while( i.hasNext() )
    {
      OutputStream out = (OutputStream)i.next();

      try
      {
        out.write( b );
        out.flush();
      }
      catch( IOException e )
      {
        i.remove();
      }
    }
  }

  public void write(byte[] b, int off, int len)
  {
    Iterator i = outs.iterator();

    while( i.hasNext() )
    {
      OutputStream out = (OutputStream)i.next();

      try
      {
        out.write( b, off, len );
        out.flush();
      }
      catch( IOException e )
      {
        i.remove();
      }
    }
  }

  public void flush()
  {
    Iterator i = outs.iterator();

    while( i.hasNext() )
    {
      OutputStream out = (OutputStream)i.next();

      try
      {
        out.flush();
      }
      catch( IOException e )
      {
        i.remove();
      }
    }
  }

  public void close()
  {
    Iterator i = outs.iterator();

    while( i.hasNext() )
    {
      OutputStream out = (OutputStream)i.next();

      try
      {
        out.close();
      }
      catch( IOException e )
      {
        i.remove();
      }
    }

    outs.clear();
  }

  public String toString()
  {
    return "[MultiOutputStream (" + hashCode() + "): " + outs.size() + " streams]";
  }
}
