package SOMA.security.utility;

import javax.naming.directory.SearchResult;
import SOMA.naming.PlaceID;
import SOMA.naming.NameException;

/** This abstract class create a SOMA naming
  *
  * Luca Ghetti
  **/

public abstract class CreateSOMAName
{

  public PlaceID place = null;

  public PlaceID getPlaceID()
  {
    return place;
  }

  public void setPlaceID (SearchResult in)
        throws NameException
  {
    this.place = this.getPlaceID ( in );
  }

  public abstract PlaceID getPlaceID (SearchResult in)
        throws NameException;



  // methods from Object class
  public String toString()
  {
    return place.toString();
  }

  public boolean equals ( Object obj )
  {
    if( !(obj instanceof CreateSOMAName) )
      return false;
    else
    {
      CreateSOMAName p = (CreateSOMAName) obj;
      return place.equals( p.place );
    }
  }

  public int hashCode()
  {
    return toString().hashCode();
  }

  public abstract Object clone();

}