package SOMA.security.infrastructure;

import java.io.*;
import java.io.PrintStream;
import com.entrust.util.*;
import com.entrust.x509.directory.*;
import com.entrust.security.provider.*;
import com.entrust.toolkit.*;
import iaik.x509.*;

public class Infrastructure implements NetAddress, InfrastructureConst
{

        public PrintStream out = System.out;

        String SearchBase = this.CA_SearchBase;

        // directory
        InfrastructureAddress directoryAddress = null;

        // profile
        EntrustProfile profile;

        // Certificate set  %%synchronized
        CertificateCRLList localCertificateCRLList = null;

        // CRL set  %%synchronized
        // LocalCRL CRL = null;

        public Infrastructure( InfrastructureAddress directoryAddress)
            throws java.io.IOException,
                   iaik.pkcs.PKCSParsingException
        {
          this.directoryAddress = directoryAddress;
          this.localCertificateCRLList = new CertificateCRLList();

          if (this.directoryAddress.getOnLine())
            this.directoryAddress.connectDirectory();
        }

        /**
         * Creates an new objects that rappresents an Entrust PKI
         * @param caIP  the ip address or hostname of the entrust authority,
         * @param dirIP the ip address or hostname of the ldap directory
         */

        public Infrastructure(String caIP,String dirIP) {
                this.directoryAddress = new InfrastructureAddress(caIP,dirIP);

                this.directoryAddress.checkCiphers();
                if (this.directoryAddress.getOnLine())
                    this.directoryAddress.connectDirectory();
                updateCertificateCRLList();
        }

        /**
         * Creates an new objects that rappresents an Entrust PKI
         * @param caIP  the ip address or hostname of the entrust authority,
         * @param dirIP the ip address or hostname of the ldap directory
         * @param onLine the directory is on line.
         */

        public Infrastructure(String caIP,String dirIP,boolean onLine) {
                this.directoryAddress = new InfrastructureAddress(caIP,dirIP,onLine);
                this.directoryAddress.checkCiphers();
                if (this.directoryAddress.getOnLine())
                    this.directoryAddress.connectDirectory();
                updateCertificateCRLList();
        }

        /**
         * Creates an new objects that rappresents an Entrust PKI
         */

        public Infrastructure() {
                this.directoryAddress = new InfrastructureAddress("localhost","localhost");
                this.directoryAddress.checkCiphers();
                if (this.directoryAddress.getOnLine())
                    this.directoryAddress.connectDirectory();
                updateCertificateCRLList();
        }


        public void setEntrustProfile ( EntrustProfile profile ) {
          this.profile = profile;
        }

        public EntrustProfile getEntrustProfile ( EntrustProfile profile ) {
          return this.profile;
        }

        public void setOut (PrintStream out){
          this.out = out;
        }


        public CertificateCRLList getCertificateCRLList ()
        {
          return localCertificateCRLList;
        }

        /**
         * This method return onLine state
         */

        public  boolean getOnLine(){
            return (this.directoryAddress != null &&
                    this.directoryAddress.getOnLine());
        }

         /**
         * This method sets the onLine parameter
         * @param onLine  it's the new value
         */

        public void setOnLine (boolean onLine){
            this.directoryAddress.setOnLine(onLine);
        }

        /**
         * This method put CA address object
         * @param   ca address
         */

        public void putInfrastructureAddress(InfrastructureAddress ia) {
                 this.directoryAddress = ia;
        }

        /**
         * This method return CA address
         * @return   ca address
         */

        public InfrastructureAddress getInfrastructureAddress() {
                 return this.directoryAddress;
        }


        public String getSearchBase () {
            return SearchBase;
        }

        public void setSearchBase ( String sb ) {
            SearchBase = sb;
        }


        // return the directory context.
        public javax.naming.directory.DirContext getDirectoryContext(){
            return this.directoryAddress.DirectoryContext;
        }

        public void connectDirectory() {
                this.directoryAddress.checkCiphers();
                if (this.directoryAddress.getOnLine())
                    this.directoryAddress.connectDirectory();
        }


        /**
         * Creates a new entrust profile. It shouldn't be used directly, but
         * through EntrustProfileManager.
         *
         * @param refnum        the reference number,
         * @param authcode      the authentication code,
         * @param password      the password used to protect the profile,
         * @param epf           the profile to be created,
         * @param signalg       the signature algorithm to be used,
         * @param filename      the file where to store the profile
         * @param mode          can be either RECOVER_PROFILE or CREATE_PROFILE
         */

        void createOrRecoverProfile(String refnum,String authcode, String password ,int signalg,String filename,int mode)
                throws java.io.FileNotFoundException,
                       com.entrust.security.exceptions.EntrustBaseException
        {
          createOrRecoverProfile( refnum, authcode, password, this.profile, signalg, filename, mode);
        }

        void createOrRecoverProfile(String refnum,String authcode, String password,EntrustProfile epf,int signalg,String filename,int mode)
                throws java.io.FileNotFoundException,
                       com.entrust.security.exceptions.EntrustBaseException

        {

                FileOutputStream out = new FileOutputStream(filename);

                EntrustManagerTransport transport = directoryAddress.getTransport();

                try {
                        if (mode == directoryAddress.CREATE_PROFILE) {
                            System.out.println("!!!  refnum : " +  refnum);
                            System.out.println("!!!  authcode : " + authcode);
                            System.out.println("!!!  password : " + password);
                            System.out.println("!!!  signalg : " + signalg);

                            epf.create(new StringBuffer(refnum),new StringBuffer(authcode),new StringBuffer(password),transport,signalg,null);
                        }
                        else if (mode == directoryAddress.RECOVER_PROFILE)
                                epf.recover(new StringBuffer(refnum),new StringBuffer(authcode),new StringBuffer(password),transport,signalg,null);
                        epf.write(out);

                } catch (com.entrust.security.exceptions.EntrustBaseException ex) {
                        epf.writeComplete(transport,false);
                        throw ex;
                }
                epf.writeComplete(transport,true);
        }

        /**
         * Check if an update is needed and performs it.
         * @param epf   the profile to pbe updated
         * @param filename the filename where to store the updated profile
         */
        public void updateProfile( String filename )
                throws  com.entrust.security.exceptions.EntrustBaseException
        {
          updateProfile(this.profile, filename);
        }


        public void updateProfile(EntrustProfile profile,String filename)
                throws  com.entrust.security.exceptions.EntrustBaseException
        {
                this.directoryAddress.checkCiphers();

                if (! directoryAddress.getOnLine())
                        return;

                if (profile.encryptionKeyUpdateRequired())
                        doKeyUpdate(profile,EntrustProfile.EncryptionKeys,filename);

                if (profile.signingKeyUpdateRequired())
                        doKeyUpdate(profile,EntrustProfile.SigntureKeys,filename);
        }

        /**
         * Used to update the keys
         */

        public void doKeyUpdate(int key_type,String filename)
                throws  com.entrust.security.exceptions.EntrustBaseException
        {
          doKeyUpdate(this.profile , key_type, filename);
        }

        public void doKeyUpdate(EntrustProfile profile,int key_type,String filename)
                throws  com.entrust.security.exceptions.EntrustBaseException
        {
                this.directoryAddress.checkCiphers();

                EntrustManagerTransport transport = this.directoryAddress.getTransport();

                if (profile.updateKeys(transport,key_type)) {
                        try {
                                FileOutputStream epf = new FileOutputStream(filename);
                                profile.write(epf);
                        } catch (Exception any) {
                                profile.writeComplete(transport,false);
                                return;
                        }
                        profile.writeComplete(transport,true);
                }
        }


        /**
         * Returns an array of valid certificates.
         * @param epf     the profile for the user who is asking for verify,
         * @param dn      the array of distinguished name for whom to verify and ....
         * @return an array of valid certificates
         */
        public X509Certificate[] getValidCertificates(String dn[])
        {
          return getValidCertificates(this.profile, dn);
        }

        public X509Certificate[] getValidCertificates(EntrustProfile epf,String dn[])
        {
                JNDIDirectory directory = null;
                // If in online mode get the directory
                if (this.directoryAddress.getOnLine())
                    directory = this.directoryAddress.getDirectory();


                // Create the verifierier

                ETKCertificateVerifier verifier = new ETKCertificateVerifier(directory,epf);
                verifier.getContext().setCrlsRequired(this.directoryAddress.getOnLine());

                verifier.validateCertificates(dn);

                return verifier.getValidCertificates();

        }

        /**
         * Returns an array of valid certificates.
         * @param epf   the profile for the user who is asking for verify,
         * @param certs the array of certificate to verify,
         * @return an array of valid certificates
         */

        public X509Certificate[] getValidCertificates(X509Certificate certs[])
        {
          return getValidCertificates(this.profile , certs);
        }

        public X509Certificate[] getValidCertificates(EntrustProfile epf,X509Certificate certs[])
        {
                JNDIDirectory directory = null;
                // If in online mode get the directory
                if (this.directoryAddress.getOnLine())

                    directory = this.directoryAddress.getDirectory();

                // Create the verifier
                ETKCertificateVerifier verifier = new ETKCertificateVerifier(directory,epf);
                verifier.getContext().setCrlsRequired(this.directoryAddress.getOnLine());
                //modifica di rebecca al 23 novembre
                boolean ret = verifier.validateCertificates(certs);
                System.out.println(" il ritono della verifica : "  + ret  );
                return verifier.getValidCertificates();

        }


        /**
         * Returns a certificate.
         * @param epf     the profile for the user who is asking for verify,
         * @param dn      the array of distinguished name for whom to verify and,
         * @param dirVer  access to directory,
         * @return an array of valid certificates
         */
        public X509Certificate getCertificate(String dn,boolean dirVer) throws
                    java.io.IOException,
                    iaik.pkcs.PKCSParsingException
        {
          return getCertificate(this.profile , dn , dirVer);
        }


        public X509Certificate getCertificate(EntrustProfile epf,String dn,boolean dirVer) throws
                    java.io.IOException,
                    iaik.pkcs.PKCSParsingException
        {
                JNDIDirectory directory;
                // If in online mode get the directory
                if (this.directoryAddress.getOnLine() && dirVer){
                    directory = this.directoryAddress.getDirectory();

                // if (dirVer){
                // Connect to the directory
                    String dnIn[] = {dn};
                    X509Certificate certs[] = getValidCertificates(epf, dnIn);
                    if (certs == null || certs.length<1) return null;
                    for(int i=0; i<certs.length; i++)
                        // Add new cer in local CertificateCRLList
                        if (! this.localCertificateCRLList.CertificateInList(certs[i]))
                            this.localCertificateCRLList = this.localCertificateCRLList.putCertificate(certs[i]);

                    return certs[0];
                }
                else {
                // Reserch into the list.
                    X509Certificate certRet = this.localCertificateCRLList.getCertificate(dn);

                    return (this.localCertificateCRLList.certInCRL(certRet) ? null : certRet);
                }
        }

        /**
         * Returns a certificate.
         * @param epf   the profile for the user who is asking for verify,
         * @param certs the array of certificate to verify,
         * @param dirVer  access to directory,
         * @return an array of valid certificates
         */
        public X509Certificate getCertificate( X509Certificate cert, boolean dirVer ) throws
                    java.io.IOException,
                    iaik.pkcs.PKCSParsingException
        {
          return getCertificate(this.profile , cert, dirVer);
        }

        public X509Certificate getCertificate(EntrustProfile epf,X509Certificate cert, boolean dirVer) throws
                    java.io.IOException,
                    iaik.pkcs.PKCSParsingException
        {
                JNDIDirectory directory;
                // If in online mode get the directory
                if (this.directoryAddress.getOnLine() && dirVer){
                    directory = this.directoryAddress.getDirectory();

                // if (dirVer){
                // Connect to the directory
                    X509Certificate certsIn[] = {cert};
                    X509Certificate certs[] = getValidCertificates(epf, certsIn);
                    if (certs == null || certs.length<1) return null;
                    for(int i=0; i<certs.length; i++)
                        // Add new cer in local CertificateCRLList
                        if (! this.localCertificateCRLList.CertificateInList(certs[i]))
                            this.localCertificateCRLList = this.localCertificateCRLList.putCertificate(certs[i]);

                    return certs[0];
                }
                else {
                // Reserch into the list.
                    X509Certificate certRet = this.localCertificateCRLList.getCertificate(cert);

                    return (this.localCertificateCRLList.certInCRL(certRet) ? null : certRet);
                }
        }



        /**
         * Download the certificates from the directory.
         * @param epf   the profile for the user who is asking for download,
         * @param dn    the array of distinguish names to download,
         * @return an array of valid certificates
         */
        public long initCertificateCRLList ( String dn[] )
                throws java.io.IOException,
                       iaik.pkcs.PKCSParsingException
        {
          return initCertificateCRLList ( this.profile , dn );
        }


        public long initCertificateCRLList (EntrustProfile epf, String dn[])
                throws java.io.IOException,
                       iaik.pkcs.PKCSParsingException
        {
            // the directory must be onLine mode for dowload certificates
            if (this.directoryAddress.getOnLine()){

                 // contact the directory for download the certificates.
                 X509Certificate[] x509 = this.getValidCertificates(epf,dn);
                 // init a new list insert certificates in the list.

                 this.localCertificateCRLList = new CertificateCRLList();
                 this.localCertificateCRLList.setCertificateList(x509);
                 //   this.localCertificateCRLList.setCRLList( );
                 return (x509.length);
            }

            return 0;
        }




        // CRL operation

       /** This method add crl array in localCertificateCRLList.
         * The crl distribution point is the directory address.
         **/

        private void updateLocalCRL() throws
                com.entrust.x509.X509Exception,
                java.security.cert.CRLException {
            // update CRL list with the certificte from the directory.
            this.localCertificateCRLList.setCRLList((this.directoryAddress.getDirectory()).getCRLs(this.CRL_LDAP_DistributionPoint().toString(),false));
        }

       /** This method return the CRLDistributionPoints name of the directory.
         */

        private iaik.x509.extensions.CRLDistributionPoints CRL_LDAP_DistributionPoint(){
            iaik.asn1.structures.Name distributionPointName = new iaik.asn1.structures.Name();

            //distributionPointName.addRDN(ObjectID.country, "IT");
            //distributionPointName.addRDN(ObjectID.locality, "IngBo");
            //distributionPointName.addRDN(ObjectID.organization ,"TU Graz");
            //distributionPointName.addRDN(ObjectID.organizationalUnit ,"IAIK");
            //distributionPointName.addRDN(ObjectID.commonName ,"http://ca.iaik.com/");
            iaik.asn1.structures.DistributionPoint distributionPoint = new iaik.asn1.structures.DistributionPoint(distributionPointName);
            //distributionPoint.setReasonFlags(DistributionPoint.keyCompromise);

            iaik.asn1.structures.GeneralNames generalNames = new iaik.asn1.structures.GeneralNames();
            generalNames.addName(new iaik.asn1.structures.GeneralName(iaik.asn1.structures.GeneralName.iPAddress, this.directoryAddress.getManagerIP() + ":" + this.directoryAddress.getManagerPort()));
            distributionPoint.setCrlIssuer(generalNames);
            iaik.x509.extensions.CRLDistributionPoints cRLDistributionPoints = new iaik.x509.extensions.CRLDistributionPoints(distributionPoint);

            return cRLDistributionPoints;
        }

        /** Update the certificate list and the CRL list.
          *
          *
          */
        public boolean updateCertificateCRLList ()
        { // initCertificateCRLList()

          boolean Update = false;
          try {
            if (this.directoryAddress != null)
            {

              if ( this.localCertificateCRLList == null )
                this.localCertificateCRLList = new CertificateCRLList();

              if ( this.directoryAddress.onLine )
              {
                // Aggiornamento CRL
                System.out.println("!!!!!!!!!!! Creazione della CRL ");

                X509CRL[] newCRL = directoryAddress.getCRL(SearchBase,false);
                if ((Update = (newCRL != null)))
                {
                  this.localCertificateCRLList.setCRLList( newCRL );

                  for (int i=0; i<newCRL.length; i++)
                  {
                   FileOutputStream fos = new FileOutputStream(System.getProperty( "user.dir" ) +
                                               File.separator + "CRLs" +
                                               File.separator +
                                               "crl" + i + ".dat", false);
                   fos.write( newCRL[i].toByteArray());
                   fos.close();
                  }
                }
                System.out.println("!!!!!!!!!!! newCRL.length = " + newCRL.length);
                for (int i=0; i<newCRL.length; i++)
                  System.out.println("  newCRL= " + newCRL[i].toString(true) );

                // Aggiornamento Certificati
                /** Per ora non utilizziamo questa parte che serve solo per cifrare
                Vector vectorOfName = new Vector();
                NamingEnumeration en = directoryAddress.connectDirectory().Search(SearchBase,"cn=*"); // en = com.sun.jndi.ldap.LdapSearchEnumeration

                Field ff [] = en.getClass().getDeclaredFields();

                for (int j=0; j<ff.length; j++)
                    System.out.println("        metodi di java:   " + ff[j].toString() );

                EntrustToSoma conversionTool = new EntrustToSoma();
                System.out.println("!!!!!!!!!!! Prima di entrare    en = " + en.getClass().getName() );

                for (int i=0; en.hasMore(); i++)
                {
                  SearchResult sr = (javax.naming.directory.SearchResult) en.next();
                  System.out.println("Elemento: " + i + "       name:" + sr.getName() + "name:" + conversionTool.getPlaceID( sr ));
                  vectorOfName.add( conversionTool.getPlaceID( sr ) );  //javax.naming.directory.SearchResult en.next();
                }
                System.out.println("!!!!!!!!!!! Get certificate ");

                String arrayOfName [] = ( String [] ) vectorOfName.toArray();
                for (int j=0; j< arrayOfName.length; j++)
                    System.out.println("        arrayOfName[" + j + "] = " + arrayOfName[j]);

                X509Certificate X509 [] = this.getValidCertificates( this.profile , arrayOfName );
                if (( Update = ( (X509 != null) || Update ) ))
                  this.localCertificateCRLList.setCertificateList ( X509 ); **/
              }
            }
          } catch (Exception e) { out.println(" Cannot update CRLs. " + e); }
          return Update;
        }

}
