package SOMA.security.infrastructure;


import java.io.InputStream;
import java.util.Date;
import java.util.Calendar;
import java.util.Enumeration;
import java.security.Principal;

import iaik.pkcs.PKCS7CertList;
import iaik.x509.X509CRL;
import iaik.x509.X509Certificate;

/* This class extends the class PKCS7CertList.
 *  Add same method to access to the directory.
 */

public class CertificateCRLList extends PKCS7CertList implements java.io.Serializable {

    protected Date lastCRLUpdate = null;
    protected Date lastCertUpdate = null;

    // default constructors
    public CertificateCRLList ()
       throws java.io.IOException,
              iaik.pkcs.PKCSParsingException
    {
    // Default constructor.
        super();
    }

    /**
     * Constructor a CertList with an input; see the method
     *       void writeTo(java.io.OutputStream os) for the output
     * @param is   is the imput stream for load a cerification list.
     */
    public CertificateCRLList(InputStream is)
       throws java.io.IOException,
              iaik.pkcs.PKCSParsingException
    {
    //  Creates a PKCS7CertList form an input stream.
        super(is);
        this.lastCertUpdate = Calendar.getInstance().getTime();
    }

    /**
     * Constructor a CertList with an array of cert; see the method
     *       void writeTo(java.io.OutputStream os) for the output
     * @param cert   is an array of Cerificate for load a cerification list.
     */
    public CertificateCRLList( X509Certificate[] certificateList, X509CRL[] crlList )
        throws java.io.IOException,
               iaik.pkcs.PKCSParsingException
    {
    //  Creates a PKCS7CertList form an input stream.
        super();
        this.setCertificateList(certificateList);
        //this.lastCertUpdate = Calendar.getInstance().getTime();
        this.setCRLList(crlList);
    }


    public boolean CertificateInList( X509Certificate cert )
    {
        X509Certificate[] certs = this.getCertificateList();
        boolean find = false;

        for (int i=0;!find && i<certs.length; i++)
            find = cert.equals(certs[i]);

        return find;
    }


    public boolean CertificateInList( String dn )
    {
        X509Certificate[] certs = this.getCertificateList();
        boolean find = false;

        for (int i=0;!find && i<certs.length; i++)
            find = dn.equals(certs[i].getSubjectDN());

        return find;
    }

    public CertificateCRLList putCertificate(X509Certificate cert)
       throws java.io.IOException,
              iaik.pkcs.PKCSParsingException
    {
        X509Certificate cl[]  = this.getCertificateList();
        X509Certificate rCL[] = new X509Certificate[cl.length + (this.CertificateInList(cert) ? 0 : 1)];

        for(int i=0; i<cl.length; i++)
            rCL[i]=cl[i];
        if(! this.CertificateInList(cert)) rCL[rCL.length-1] = cert;

        CertificateCRLList retcl = new CertificateCRLList();
        retcl.setCertificateList(rCL);

        return retcl;
    }

    public X509Certificate getCertificate ( String dn )
    {
        X509Certificate[] certs = this.getCertificateList();
        int i;

        for (i=0;!dn.equals(certs[i].getSubjectDN()) && i<certs.length; i++){}

        if (i >= certs.length) return null;
        else return certs[i];
    }


    public X509Certificate getCertificate ( X509Certificate cert )
    {
        X509Certificate[] certs = this.getCertificateList();
        int i;

        for (i=0;!cert.equals(certs[i]) && i<certs.length; i++){}

        if (i >= certs.length) return null;
        else return certs[i];
    }


    public boolean isEmpty ()
    {
        return (((this.getCertificateList()) == null) ||
                ((this.getCertificateList()).length == 0));
    }


    public long lengthCert ()
    {
        X509Certificate[] certs = this.getCertificateList();
        return (certs==null ? 0 : certs.length);
    }

    public long lengthCRL ()
    {
        X509CRL[] crl = this.getCRLList();
        return (crl==null ? 0 : crl.length);
    }


    // Returns the Distinguished Name of the issuer of this CRL,
    // as java.security.Principal
    public Principal getIssuerDN ( int position )
    {
        X509CRL crl[] = this.getCRLList();
        return (((crl!=null) && (position>=0) && (position<crl.length)) ?
                    (java.security.Principal)crl[position].getIssuerDN() :
                    null );
    }

    // Returns the Distinguished Name of the issuer of this CRL,
    // as java.security.Principal
    public Principal getIssuerDN ()
    {
        X509CRL crl[] = this.getCRLList();
        return (((crl!=null) && (0<crl.length)) ?
                    (java.security.Principal)crl[0].getIssuerDN() :
                    null );
    }

    public boolean certInCRL ( X509Certificate certs [] )
    {
        boolean answer = false;
        if ( certs == null ) return false;

        for (int j=0; ( j<certs.length ) &&
                      (! (answer = ( this.certInCRL( certs[j] ) )) )  ; j++) {}

        return answer;
    }

    public boolean certInCRL ( X509Certificate cert )
    {
        if ( cert == null ) return false;

        X509CRL crl[] = this.getCRLList();

        if (crl==null) return false;

        boolean Revoked = false;

        for (int i=0; (i<crl.length) && !(Revoked=crl[i].isRevoked(cert)); i++){}
        return Revoked;

    }

    //Returns an array enumeration of the revoked certificates this CRL contains.
    public Enumeration [] listRevockedCertificates ()
    {
        X509CRL crl[] = this.getCRLList();
        if (crl==null) return null;

        Enumeration [] list = new Enumeration [crl.length];
        for (int i=0; i<crl.length; i++)
            list[i] = crl[i].listCertificates();

        return list;
    }

    //Set the CRLs for this PKCS#7 SignedData object.
    public void setCRLList ( X509CRL[] crlList )
    {
      super.setCRLList( crlList );
      this.lastCRLUpdate = Calendar.getInstance().getTime();
    }

    public void setCertificateList(X509Certificate[] certificateList)
    {
      super.setCertificateList( certificateList );
      this.lastCertUpdate = Calendar.getInstance().getTime();
    }

    public Date getLastCRLUpdate ()
    {
      return this.lastCRLUpdate;
    }

    public Date getLastCertUpdate ()
    {
      return this.lastCertUpdate;
    }

    public String toString ()
    {
      X509CRL[] crl = this.getCRLList();
      String crlMsg = "";
      X509Certificate[] certs = this.getCertificateList();
      String certMsg = "";

      for (int i=0; (crl!=null) && (crl.length<i); i++)
        crlMsg = crl[i].toString() + "\n";
      for (int i=0; (certs!=null) && (certs.length<i); i++)
        certMsg = certs[i].toString() + "\n";

      return (("<class name: " + this.getClass().getName() + ">\n") +
              (this.lastCRLUpdate == null ?
                              "" :
                              "Last CRL Update: " + this.lastCRLUpdate.toString() + "\n") +
              crlMsg +
              (this.lastCertUpdate == null ?
                              "" :
                              "Last Cert Update: " + this.lastCertUpdate.toString() + "\n") +
              certMsg);
    }

 /** Methods inherited from class iaik.pkcs.PKCS7CertList
  *
  *   X509Certificate[] getCertificateList()
  *        Returns the certificates included in this PKCS7CertList object.
  *   X509CRL[] getCRLList()
  *        Returns the CRLs included in this PKCS7CertList object.
  *   void setCertificateList(X509Certificate[] certificateList)
  *        Set the certificates for this PKCS#7 SignedData object.
  *   byte[] toByteArray()
  *        Returns this PKCS7CertList object as DER encoded byte array.
  *   java.lang.String toString()
  *        Returns a string giving some information about the contents of this
  *        PKCS7CertList object.
  *   void writeTo(java.io.OutputStream os)
  *        Writes the certificate chain to the given output stream.
  *
  *
  ** Methods inherited from class java.lang.Object
  *
  *   equals, getClass, hashCode, notify, notifyAll, wait, wait, wait
  *
  **/
}
