package SOMA.security.auth;

import iaik.x509.*;
import iaik.x509.extensions.*;

/**
*
* @author Mario Zambrini
* @version
*/
public class X509RoleCertificate {

  X509Certificate cert;

  public X509RoleCertificate(X509Certificate cert) {

    this.cert=cert;

  }

  public X509Certificate getX509Certificate() {

    return this.cert;

  }

  public String getRole() {

    SubjectAltName roleExtension;

    try {
    roleExtension=(SubjectAltName)this.cert.getExtension(SubjectAltName.oid);
    return roleExtension.getGeneralNames().toString().substring(12);

    } catch (X509ExtensionInitException ex) {

      ex.printStackTrace();
      return null;

    }

  }

  public String toString() {

    return this.cert.toString()+"\n Ruolo: "+getRole();

  }

}
