package SOMA.security.auth;

import java.util.*;
import java.io.*;

import javax.security.auth.*;
import javax.security.auth.callback.*;
import javax.security.auth.login.*;
import javax.security.auth.spi.*;

import SOMA.security.infrastructure.*;

import com.entrust.security.exceptions.*;
import iaik.x509.X509Certificate;

/*
  Modulo di login.

  Verifico profileName e password e nel caso
  siano corretti associo i ruoli scelti dall'utente al soggetto da creare.

  L'implementazione e' quella standard di un modulo di login del JAAS

*/

public class SomaUserLoginModule implements LoginModule {

  // initial state
  private Subject subject;
  private CallbackHandler callbackHandler;
  private Map sharedState;
  private Map options;

  // configurable option
  private boolean debug = false;

  // the authentication status
  private boolean succeeded = false;
  private boolean commitSucceeded = false;

  //  Informazioni persistenti
  private String profileName;
  private String profilePassword;
  private X509Certificate identityCert;
  private UserPrincipal userPrincipal;
  private RolePrincipal rolePrincipal;
  private Role role;

  // Informazioni Temporanee
  private Infrastructure pki;
  private char[] password;
  private String[] roleNames;
  private String selectedRoleName;
  private Role[] roles;
  private ProfileManager userProfileManager;

  public void initialize(Subject subject, CallbackHandler callbackHandler,Map sharedState, Map options) {

    this.subject = subject;
    this.callbackHandler = callbackHandler;
    this.sharedState = sharedState;
    this.options = options;

    // initialize any configured options
    debug = "true".equalsIgnoreCase((String)options.get("debug"));

    // Inizializzo l'infrastruttura
    InfrastructureAddress pkiAddress=new InfrastructureAddress(NetAddress.CA_IP,NetAddress.DIR_IP,true);
    try {
      this.pki=new Infrastructure(pkiAddress);
    } catch (Exception ex) {

      ex.printStackTrace();

    }

  }

  public boolean login() throws LoginException {

    // prompt for a profileName and password
    if (callbackHandler == null)
      throw new LoginException("Errore: nessun CallBackHandler per richiedere informazioni");

    Callback[] callbacks = new Callback[2];
    callbacks[0] = new NameCallback("Profile Name: ");
    callbacks[1] = new PasswordCallback("Password: ", false);

    try {

      callbackHandler.handle(callbacks);

      profileName = ((NameCallback)callbacks[0]).getName();
      char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
      if (tmpPassword == null) {
        // treat a NULL password as an empty password
        tmpPassword = new char[0];
      }
      password = new char[tmpPassword.length];
      System.arraycopy(tmpPassword, 0,password, 0, tmpPassword.length);
      ((PasswordCallback)callbacks[1]).clearPassword();

    } catch (java.io.IOException ioe) {

      throw new LoginException(ioe.toString());

    } catch (UnsupportedCallbackException uce) {

      throw new LoginException("Errore: " + uce.getCallback().toString() +
        "impossibile ottenere le informazioni di autenticazione.");
    }

    // print debugging information
    if (debug) {
      System.out.println("\t\t[SomaUserLoginModule] " +
        "user entered profileName: " +
        profileName);
      System.out.print("\t\t[SomaUserLoginModule] " +
        "user entered password: ");
      for (int i = 0; i < password.length; i++)
        System.out.print(password[i]);
      System.out.println();
    }

    // verify the profileName/password

    if (verifyUserInfo(profileName,password)) {

      // authentication succeeded!!!
      if (debug) {
        System.out.println("\t\t[SomaUserLoginModule] authentication succeeded");
        System.out.println(identityCert.getSubjectDN().getName());
      }

    } else {

      // authentication failed -- clean out state
      if (debug)
        System.out.println("\t\t[SomaUserLoginModule] " +
        "authentication failed");
      succeeded = false;
      profileName = null;
      for (int i = 0; i < password.length; i++)
        password[i] = ' ';
      password = null;
      throw new FailedLoginException("Login Incorrect");
    }

    // Chiedo i ruoli all'utente
    // per ora getUserRoles() torna dei valori fittizzi
    // con cui si possono comunque fare delle prove.
    // Successivamente getUserRoles dovr implementare
    // la richiesta ad un servizio di directory per recuperare
    // i ruoli di un determinato utente.
    getUserRoles();

    callbacks = new Callback[1];
    callbacks[0] = new ChoiceCallback("Select Role",roleNames,0,false);

    try {

        callbackHandler.handle(callbacks);

        int[] selectedIndexes=((ChoiceCallback)callbacks[0]).getSelectedIndexes();

        if (selectedIndexes.length>1)
          throw new FailedLoginException("Impossibile definire ruoli multipli");

        selectedRoleName=roleNames[selectedIndexes[0]];
        role=roles[selectedIndexes[0]];

    } catch (java.io.IOException ioe) {

      throw new LoginException(ioe.toString());

    } catch (UnsupportedCallbackException uce) {

      throw new LoginException("Errore: " + uce.getCallback().toString() +
        "impossibile ottenere le informazioni di autenticazione.");
    }

    succeeded = true;
    return true;

  }

  private boolean verifyUserInfo(String profileName,char[] password) {


    try {

    userProfileManager=new ProfileManager(pki);
    profilePassword=new String(password);
    userProfileManager.logonProfile(profileName,profilePassword);
    identityCert=userProfileManager.getProfile().getSigningCertificate();

    } catch (FileNotFoundException ex) {

      System.out.println("Verifica profilo "+profileName+": File non trovato.\n");
      //ex.printStackTrace();
      return false;

    } catch (EntrustBaseException ex) {

      System.out.println("Verifica profilo "+profileName+": Errore nel Profilo.\n");
      //ex.printStackTrace();
      return false;

    } catch (Exception ex) {

      System.out.println("Verifica profilo "+profileName+": Unknow Exception.\n");
      //ex.printStackTrace();
      return false;

    }

    return true;

  }

  public boolean commit() throws LoginException {

    if (succeeded == false) {
      return false;
    } else {

      userPrincipal=new UserPrincipal(identityCert.getSubjectDN().getName());
      rolePrincipal=new RolePrincipal(selectedRoleName);

      final Subject s = subject;
      final UserPrincipal up=userPrincipal;
      final RolePrincipal rp=rolePrincipal;
      final String pn=profileName;
      final String ppwd=profilePassword;
      final X509Certificate ic=identityCert;
      final Role ro=role;

      java.security.AccessController.doPrivileged
        (new java.security.PrivilegedAction() {

          public Object run() {

            if (!s.getPrincipals().contains(up))
              s.getPrincipals().add(up);
            if (!s.getPrincipals().contains(rp))
              s.getPrincipals().add(rp);
            if (!s.getPrivateCredentials().contains(pn))
               s.getPrivateCredentials().add(pn);
            if (!s.getPrivateCredentials().contains(ppwd))
               s.getPrivateCredentials().add(ppwd);
            if (!s.getPublicCredentials().contains(ic))
               s.getPublicCredentials().add(ic);
           if (!s.getPublicCredentials().contains(ro))
               s.getPublicCredentials().add(ro);


            return null;
          }
        });

      if (debug) {
        System.out.println("\t\t[SomaUserLoginModule] " +
        "added UserPrincipal and RolePrincipal to Subject");
      }

      // in any case, clean out state
      for (int i = 0; i < password.length; i++)
      password[i] = ' ';
      password = null;
      for (int i=0;i<roleNames.length;i++)
        roleNames[i]=null;
      selectedRoleName=null;
      for (int i=0;i<roles.length;i++)
        roles[i]=null;
      userProfileManager.logoffProfile();

      commitSucceeded = true;
      return true;

    }

  }

  public boolean abort() throws LoginException {

    if (succeeded == false) {
      return false;
    } else if (succeeded == true && commitSucceeded == false) {

      // login succeeded but overall authentication failed
      succeeded = false;

      if (password != null) {
      for (int i = 0; i < password.length; i++)
        password[i] = ' ';
      password = null;
      }
      for (int i=0;i<roleNames.length;i++)
        roleNames[i]=null;
      selectedRoleName=null;
      for (int i=0;i<roles.length;i++)
        roles[i]=null;
      userProfileManager.logoffProfile();


    } else {
      // overall authentication succeeded and commit succeeded,
      // but someone else's commit failed
      logout();
    }

    return true;

  }

  public boolean logout() throws LoginException {

    final Subject s = subject;
    final UserPrincipal up=userPrincipal;
    final RolePrincipal rp=rolePrincipal;
    final String pn=profileName;
    final String ppwd=profilePassword;
    final X509Certificate ic=identityCert;
    final Role ro=role;

    java.security.AccessController.doPrivileged
      (new java.security.PrivilegedAction() {

        public Object run() {

          s.getPrincipals().remove(up);
          s.getPrincipals().remove(rp);
          s.getPrivateCredentials().remove(pn);
          s.getPrivateCredentials().remove(ppwd);
          s.getPublicCredentials().remove(ic);
          s.getPublicCredentials().remove(ro);

          return null;
        }

      });

    succeeded = false;
    succeeded = commitSucceeded;

    if (password != null) {
      for (int i = 0; i < password.length; i++)
        password[i] = ' ';
      password = null;
    }
    for (int i=0;i<roleNames.length;i++)
      roleNames[i]=null;
    selectedRoleName=null;
    for (int i=0;i<roles.length;i++)
        roles[i]=null;
    userProfileManager.logoffProfile();

    userPrincipal=null;
    rolePrincipal=null;
    profileName=null;
    profilePassword=null;
    identityCert=null;
    role=null;

    return true;
  }

  private void getUserRoles() {

    final int ROLE_NUM=2;
    String[] profileNames={"profili\\somauser1","profili\\somauser2"};
    char[][] profilePasswords={{'s','o','m','a','u','s','e','r','1','P','W','D'},{'s','o','m','a','u','s','e','r','2','P','W','D'}};
    ProfileManager[] profileManagers=new ProfileManager[ROLE_NUM];
    X509Certificate[] certs=new  X509Certificate[2];

    roleNames=new String[2];
    roles=new Role[ROLE_NUM];

    for (int i=0;i<ROLE_NUM;i++) {

      try {

        profileManagers[i]=new ProfileManager(pki);
        profileManagers[i].logonProfile(profileNames[i],new String(profilePasswords[i]));
        certs[i]=profileManagers[i].getProfile().getSigningCertificate();

        //if (debug) {
        //  System.out.println("\t\t[SomaUserLoginModule] trovato certificato "+i+"\n");
        //  System.out.println(certs[i].getX509Certificate().getSubjectDN().getName()+" "+certs[i].getRole());
        //}

        roles[i]=new Role(certs[i]);
        roleNames[i]=roles[i].getRoleName();
        profileManagers[i].logoffProfile();

      } catch (FileNotFoundException ex) {

        System.out.println("Verifica profilo "+profileName+": File non trovato.\n");
        ex.printStackTrace();

      } catch (EntrustBaseException ex) {

        System.out.println("Verifica profilo "+profileName+": Errore nel Profilo.\n");
        ex.printStackTrace();

      }

    }

  }

  // End of Class

}
