package SOMA.security.auth;

import iaik.x509.*;
import iaik.x509.extensions.*;

/**
*
* @author Mario Zambrini
* @version
*/
public class Role extends Object {

  String roleName;
  X509Certificate roleCert;

  public Role(X509Certificate roleCert) {

    this.roleCert=roleCert;
    this.roleName=extractRoleName();

  }

  public String getRoleName() {

    return this.roleName;

  }

  public X509Certificate getX509Certificate() {

    return this.roleCert;

  }

  private String extractRoleName() {

    SubjectAltName roleExtension;

    try {
    roleExtension=(SubjectAltName)this.roleCert.getExtension(SubjectAltName.oid);
    return roleExtension.getGeneralNames().toString().substring(12);

    } catch (X509ExtensionInitException ex) {

      ex.printStackTrace();
      return null;

    }

  }

  public String toString() {

    return "\n Ruolo: "+this.roleName+"\n Certificato di Ruolo: "+this.roleCert.toString();

  }

}
