package SOMA.security.auth;

import SOMA.explorer.*;
import SOMA.security.*;
import SOMA.mobilePlace.*;

import java.io.*;
import java.util.*;

/** Classe di avvio del sistema.
*
* L'unico metodo  {@link #main( String[] args ) main}, non ci sono campi.
*
* @author Livio Profiri
*/
public class MainSecurity extends Object
{
  /**
  * Metodo di avvio del sistema:
  * <UL>
  * <LI> Costruisce un menu ({@link SOMA.explorer.DirExplorerItem}) aggiungendo alcuni sottomenu.
  * <LI> Aggiunge un sottomenu per la gestione di socket {@link SOMA.network.connection}.
  * <LI> Aggiunge un sottomenu di utility {@link SOMA.utility}.
  * <LI> Aggiunge il comando per la creazione di un dominio {@link SOMA.NewDomainExplorerItem}.
  * <LI> Aggiunge il comando per la creazione di un place {@link SOMA.NewPlaceExplorerItem}.
  * <LI> Aggiunge il comando per l'esecuzione di script {@link SOMA.explorer.LoadExplorerItem}.
  * <LI> Se dalla linea di comando era stato specificato un parametro <code>java SOMA.Main fileName</code>
  *    esegue lo script <code>fileName</code>.
  * <LI> Aggiunge il comando di uscita.
  * <LI> Avvia il thread del menu: {@link SOMA.explorer.ExplorerThread}.
  * </UL>
  */

  static public void main( String[] args )
  {
    DirExplorerItem Root = buildMenu();

    if( args.length > 0 )
    {
      for( int i = 0; i < args.length; i++ )
      {
        System.out.println( "  " + (i + 1) + ") Loading file " + args[i] + "..." );
        try
        {
          InputStream is = new FileInputStream( args[i] );

          new ExplorerThread( Root, is, System.out, true ).start();
        }
        catch( Exception e )
        {
          System.out.println( e );
        }
        System.out.println();
      }
    }

    Root.addItem( "end", new ExplorerItem( "Terminates the Java Virtual Machine!" )
      {
        public Object Execute( Collection Parameters, PrintStream out )
        {
          if( Parameters.size() == 0 )
            System.exit( 0 );
          else
            out.println( "NO PARAMETERS to exit the system!" );

          return null;
        }
      });

    // Ho cambiato solo le righe di codice in cui lanciava ExplorerThread
    // per lanciare al suo posto ExplorerThreadGUI
    // Mario

    ExplorerThreadGUI explorerGUI = new ExplorerThreadGUI(Root);
    Thread explorer=new Thread(explorerGUI);
    explorer.start();
  }

  public static DirExplorerItem buildMenu()
  {
    DirExplorerItem Root = new DirExplorerItem( "root" );
    //DirExplorerItem Note = new DirExplorerItem( "Note" );

    //Note.addItem( new DirExplorerItem( "Do" ) );
    //Note.addItem( new DirExplorerItem( "Re" ) );
    //Note.addItem( new DirExplorerItem( "Mi" ) );
    //Root.addItem( Note );

    //DirExplorerItem Fiori = new DirExplorerItem( "Fiori" );

    //Fiori.addItem( new DirExplorerItem( "Rosa" ) );
    //Fiori.addItem( new DirExplorerItem( "Giglio" ) );
    //Root.addItem( Fiori );

    DirExplorerItem Crono = new DirExplorerItem( "crono" );
    Crono.addItem( "uno", new SOMA.utility.ChronometerExplorerItem( "Crono uno" ));
    Crono.addItem( "due", new SOMA.utility.ChronometerExplorerItem( "Crono due" ));
    Crono.addItem( "tre", new SOMA.utility.ChronometerExplorerItem( "Crono tre" ));
    Root.addItem( Crono );

    DirExplorerItem socket = new DirExplorerItem( "socket" );
    socket.addItem( "threads", new SOMA.utility.ThreadsExplorerItem() );
    socket.addItem( "localHost", new SOMA.utility.GetLocalHostExplorerItem() );
    socket.addItem( "NewServer", new SOMA.security.NewServerExplorerItemSecurity( socket ) );
    socket.addItem( "NewClient", new SOMA.network.connection.NewClientExplorerItem( socket ) );
    Root.addItem( socket );

    DirExplorerItem util = new DirExplorerItem( "util" );
    util.addItem( "threads", new SOMA.utility.ThreadsExplorerItem() );
    util.addItem( "localHost", new SOMA.utility.GetLocalHostExplorerItem() );
    util.addItem( "gc", new SOMA.utility.GarbageCollectionExplorerItem() );
    util.addItem( "finalize", new SOMA.utility.FinalizeExplorerItem() );
    util.addItem( "freeMem", new SOMA.utility.FreeMemoryExolorerItem() );
    util.addItem( "totalMem", new SOMA.utility.TotalMemoryExolorerItem() );
    util.addItem( "usedMem", new SOMA.utility.DiffMemoryExolorerItem() );
    util.addItem( "prop", new SOMA.utility.PropertiesExplorerItem() );
    //util.addItem( "setProp", new SOMA.utility.SetPropertyExplorerItem() );
    util.addItem( "impl", new SOMA.utility.ImpliesExplorerItem() );
    util.addItem( "refresh", new SOMA.utility.RefreshPolicyExplorerItem() );
    util.addItem( "policy", new SOMA.utility.PrintPolicyExplorerItem( "SOMA" ) );

    /*
    try
    {
      ExplorerItem ei = (ExplorerItem)Class.forName( "CheckPermissionExplorerItem" ).newInstance();
      util.addItem( "check", ei );
    }
    catch( Exception e )
    {
      e.printStackTrace();
    }*/

    Root.addItem( util );

    Root.addItem( "security", new SOMA.utility.StartSecurityManagerExplorerItem() );
    Root.addItem( "newDomain", new NewDomainExplorerItemSecurity( Root ) );
    Root.addItem( "newPlace", new NewPlaceExplorerItemSecurity( Root ) );
    Root.addItem( "newMobilePlace", new NewMobilePlaceExplorerItem( Root ) );
    Root.addItem( "load", new LoadExplorerItem( Root ) );

    return Root;
  }
}
