package SOMA.security;


import java.util.*;
import java.io.*;
import SOMA.network.connection.*;
import SOMA.explorer.*;
import SOMA.security.SecurityEnvironment;
import SOMA.Environment;

/** <P>Voce di menu che crea un nuovo {@link SOMA.network.connection.ConnectionServer server di connessioni}.
* </P><P>
* Per ogni server creato si aggiunge
* una nuova {@link SOMA.explorer.ExplorerItem voce}
* ad un {@link SOMA.explorer.DirExplorerItem menu}.
* </P><P>
* Analogamente, per ogni connessione creata dal server si aggiunge
* una nuova {@link SOMA.explorer.ExplorerItem voce}
* allo stesso {@link SOMA.explorer.DirExplorerItem menu}.
* </P>
*
* @author Luca Ghetti
*/

public class NewServerExplorerItemSecurity extends ExplorerItem
{
  /** @serial*/
  Environment env;

  /** @serial*/
  DirExplorerItem dir;

  /** Costruttore.
  * @param dir Il menu a cui aggiungere le nuove {@link SOMA.explorer.ExplorerItem voci}.
  */
  public NewServerExplorerItemSecurity( DirExplorerItem dir )
  {
    super( "port" );
    this.dir = dir;
    env = new SecurityEnvironment( dir, System.in, System.out, System.err );  // Attenzione: non usato dal sistema e tenuto a null--> rischio di errori.
  }

  /** Metodo di esecuzione. Parametro richiesto: la <B>porta</B> del server.
  */
  public Object Execute( Collection Parameters, PrintStream out )
  {
    if( Parameters.size() == 1 )
    {
      String Param = (String)Parameters.iterator().next();

      int port = 0;

      try
      {
        port = Integer.parseInt( Param );
      }
      catch( Exception e )
      {
        out.println( "ERROR: incorrect port number" + Param );
        return null;
      }

      String newItemName = "Server" + port;
      DaemonExplorerItem newServerItem = new DaemonExplorerItem(
        new ConnectionServer( port, 50,
          new ExplorableConnectionFactory( env, dir, newItemName + "_" ) ) );

      dir.addItem( newItemName, newServerItem );

      return newServerItem;
    }

    return null;
  }

  public String Help( PrintStream out )
  {
    String help = "port: Creates a new server on the specified port.";

    out.println( help );

    return help;
  }
}