package SOMA.security;

import java.util.*;
import java.io.*;

import SOMA.explorer.*;
import SOMA.Environment;
import SOMA.agent.*;
import SOMA.agent.mobility.*;
import SOMA.security.infrastructure.*;

/** Voce di menu per gestire il lancio di agenti...
* @author Livio Profiri
*/

public class AgentLauncherExplorerItemSecurity extends ExplorerItem
{
  Environment env;

  public static final String SYSTEM_CLASSLOADER = "-s";
  public static final String NOT_TRACEABLE = "-nt";
  public static final String NO_START = "-ns";
//  public static final String CA_ONLINE = "-online";
  public static final String PASSWORD_PROFILEPATH = "-p";


  public AgentLauncherExplorerItemSecurity( Environment env )
  {

    super( "[" + SYSTEM_CLASSLOADER + "] [" + NOT_TRACEABLE + "] [" + NO_START +
           "] [" + PASSWORD_PROFILEPATH + " ProfilePath ProfilePassword ] " +
           " \"Agent ID\" { \"Arg1\" \"Arg2\" ... }"  );
    this.env = env;
    //env.out.println("AgentLauncherSecurity begin");
  }

  public Object Execute( Collection Parameters, PrintStream out )
  {
    ProfileManager profile = null;

    String profilePath;
    String profilePassword;

    HashSet options = new HashSet();

    Iterator i = Parameters.iterator();

    while( i.hasNext() )
    {
      String option = (String)i.next();

      out.println( option );

      if ( option.equals( PASSWORD_PROFILEPATH ) )
      {
        i.remove();
        if (! i.hasNext() ) profile = null;
        else
        {
            profilePath = (String)i.next();
            i.remove();
            if (! i.hasNext() ) profile = null;
            else
            {
              try
              {
                env.out.println( "Logon user profile, begin." );
                options.add( PASSWORD_PROFILEPATH );
                profilePassword = (String)i.next();
                //i.remove();
                // inizializzare il profilo.

                if ( ((SecurityEnvironment)env).profile == null)
                  env.out.println( "Env.Profile is null" );
                else env.out.println( "Env.Profile ok" );
                Infrastructure pki = null;

                boolean onLine = ( ( ((SecurityEnvironment)env).profile != null) &&
                                   ( (pki = ((SecurityEnvironment)env).profile.getEntrustInfrastructure()) != null) &&
                                   ( pki.getOnLine() ));
                profile = new ProfileManager ( pki );
                // profile.setEntrustInfrastructure( pki );

                profile.logonProfile( profilePath, profilePassword, onLine );
                env.out.println( "Logon user profile, end." );
              } catch ( Exception e ) { env.out.println( "Error cannot logon profile: " + e ); }

            }
        }
      }
      if( option.startsWith( "-" ) )
      {
        i.remove(); // Rimuove il parametro dalla lista dei parametri.
        options.add( option );
      }
      else
        break;
    }

    i = Parameters.iterator();
    if( i.hasNext() )
    {
      String agentName = (String)i.next();
      i.remove();
      out.println( "Agent class: " + agentName );

      int NumParameters = Parameters.size();
      String[] ParametersArray = new String[NumParameters];

      out.println( "Creating agent: " + agentName + " Parameters: " );
      for( int j = 0; j < NumParameters; j++ )
      {
        ParametersArray[j] = (String)i.next();
        out.println( "  " + j + ")  " + ParametersArray[j] );
      }

      if( options.contains( SYSTEM_CLASSLOADER ) )
        out.println( SYSTEM_CLASSLOADER + " ==> Using System ClassLoader." );

      if( options.contains( NOT_TRACEABLE ) )
        out.println( NOT_TRACEABLE + " ==> Not Traceable agent." );

      if( options.contains( NO_START ) )
        out.println( NO_START + " ==> No Start: the agent will not be started." );

      if( options.contains( PASSWORD_PROFILEPATH ) )
        out.println( PASSWORD_PROFILEPATH + " ==> start agent signature" );

      // true --> System agent!
      AgentWorker worker =
           ((AgentManagerSecurity)env.agentManager).createAgent( agentName, ParametersArray,
                                                                 options.contains( SYSTEM_CLASSLOADER ),
                                                                 !options.contains( NOT_TRACEABLE ),
                                                                 profile );

      /** Questa operazione chiude il profilo che firma l'agente;
       *   necessario mantenere il sincronismo tra questa classe e
       *  la create agent dell'agent manager.
       */
      if ( profile != null ) profile.logoffProfile();

      if( worker == null )
        out.println( "ERROR: can't create agent." );
      else
      {
        if( options.contains( NO_START ) )
          out.println( "Worker: " + worker + " created, but not started." );
        else
        {
          try
          {
            worker.start();
          }
          catch( Exception e )
          {
            e.printStackTrace( out );
          }
          out.println( "Worker: " + worker + " created and started." );
        }
      }

      return worker;
    }

    out.println( "Invalid parameters." );

    return null;
  }

  public String Help( PrintStream out )
  {
    out.println();
    out.println( "Launch an agent with the specified options " );
    out.println( "  and parameters: " + toString() );
    out.println();
    out.println( "\"agent ID\" --> Agent class name (no .class suffix)." );
    out.println();
    out.println( "{ \"Arg1\" \"Arg2\" ... } --> Optional arguments. They will be passed in a " );
    out.println( "     String[] to Agent.putArgument( Object obj )." );
    out.println();
    out.println( SYSTEM_CLASSLOADER + " --> Use System ClassLoader. The agent will use the default" );
    out.println( "     Java security protection mechanisms" );
    out.println();
    out.println( NOT_TRACEABLE + " --> Not Traceable agent. The agent will not be traceable and " );
    out.println( "     he will not have a Mailbox to receive messages." );
    out.println();
    out.println( NO_START + " ==> No Start: the agent will not be started. It is possible to " );
    out.println( "     move the agent to another place (Worker.go(...)) or to start it later." );
    out.println();
    out.println( PASSWORD_PROFILEPATH + " ==> digit profile path and password to start agent signature." );
    out.println();

    return getSyntax();
  }
}