package SOMA.resourceManagement.windows;


import SOMA.resourceManagement.*;


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;

/** 
 * Finestra che consente di visualizzare e settare i valori delle soglie
 * sui consumi di risorse. 
 * 
 * @see SOMA.resourceManagement.windows.AgentWin
 * @see SOMA.resourceManagement.windows.ProcessWin
 * @see SOMA.resourceManagement.windows.NetworkWin
 * @see SOMA.resourceManagement.windows.AlarmWin
 * @see SOMA.resourceManagement.windows.PRMWindow
 *
 * @author Silvia Vecchi
 */
public class ThresholdWin extends JFrame implements WindowListener {
	
	public static final  String PICTURE_PATH = "SOMA"+File.separator+"gui"+File.separator+"picture"+File.separator;
	
	protected Panel1 pan1;
	protected Panel2 pan2;
	protected Container cont;
  protected	PlaceResourceManager prm;
	//non  molto pulito, ma per recuperare i valori delle soglie devo interrogare il prm
	
	public ThresholdWin(PlaceResourceManager prm) {
		super("Resource Consumption Thresholds");
		this.prm=prm;
		setBounds(30,30,700,400);
		cont=getContentPane();
	  pan1=new Panel1();
	  pan1.setLayout(new GridLayout(6,3,5,5));
		cont.add(pan1);
		pan2=new Panel2();
		cont.add(pan2, BorderLayout.SOUTH);

		setVisible(true);
	}
	
	
	public void windowOpened(WindowEvent e){}
  public void windowClosing(WindowEvent e)
  	{dispose();}
  public void windowClosed(WindowEvent e){}
  public void windowIconified(WindowEvent e){}
  public void windowDeiconified(WindowEvent e){}
  public void windowActivated(WindowEvent e){}
  public void windowDeactivated(WindowEvent e){}

  	

  private class Panel1 extends JPanel implements ActionListener{
  	JLabel cpuLabel, memLabel, bandLabel, fileInLabel, fileOutLabel, res, get, set;
  	JTextField cpuTh, setCpuTh, memTh, setMemTh, bandTh, setBandTh, fileInTh, setFileInTh, fileOutTh, setFileOutTh;
  	Threshold th;
  	
  	public Panel1(){
  	  res=new JLabel("RESOURCE");
  	  get=new JLabel("CURRENT THRESHOLD");
  	  set=new JLabel("SET NEW THRESHOLD");
  	  cpuLabel=new JLabel("      CPU  (%)", new ImageIcon(PICTURE_PATH+"RadarMaxi.gif"), SwingConstants.LEFT);
  	  memLabel=new JLabel("     Memory  (Bytes)", new ImageIcon(PICTURE_PATH+"MemoryMaxi.gif"), SwingConstants.LEFT);
  	  bandLabel=new JLabel("     Band Width  (Av.Bytes/sec)", new ImageIcon(PICTURE_PATH+"Connect.gif"), SwingConstants.LEFT);
  	  fileInLabel=new JLabel("    File Read Operations  (Op./sec)", new ImageIcon(PICTURE_PATH+"CartAggiorna.gif"), SwingConstants.LEFT);
  	  fileOutLabel=new JLabel("    File Write Operations  (Op./sec)", new ImageIcon(PICTURE_PATH+"CartInserisci.gif"), SwingConstants.LEFT);

  	  th=prm.getConsumptionThresholds();
  	    	  
  	  cpuTh=new JTextField(Float.toString(th.cpu));
  	  cpuTh.setEditable(false);
  	  setCpuTh=new JTextField();
  	  setCpuTh.setEditable(true);
  	  setCpuTh.addActionListener(this);
  	  
  	  memTh=new JTextField(Float.toString(th.mem));
  	  memTh.setEditable(false);
  	  setMemTh=new JTextField();
  	  setMemTh.setEditable(true);
  	  setMemTh.addActionListener(this);

      
      bandTh=new JTextField(Float.toString(th.band_width));
      bandTh.setEditable(false);
      setBandTh=new JTextField();
  	  setBandTh.setEditable(true);
  	  setBandTh.addActionListener(this);


      fileInTh=new JTextField(Float.toString(th.file_in));
      fileInTh.setEditable(false);
      setFileInTh=new JTextField();
  	  setFileInTh.setEditable(true);
  	  setFileInTh.addActionListener(this);


      fileOutTh=new JTextField(Float.toString(th.file_out));
      fileOutTh.setEditable(false);
      setFileOutTh=new JTextField();
  	  setFileOutTh.setEditable(true);
  	  setFileOutTh.addActionListener(this);


      add(res);
      add(get);
      add(set);
      add(cpuLabel);
      add(cpuTh);
      add(setCpuTh);
      add(memLabel);
      add(memTh);
      add(setMemTh);
      add(bandLabel);
      add(bandTh);
      add(setBandTh);
      add(fileInLabel);
      add(fileInTh);
      add(setFileInTh);
      add(fileOutLabel);
  	  add(fileOutTh);
  	  add(setFileOutTh);

  	}
  	
  	
  
  		public void actionPerformed(ActionEvent e){
  			
  			String s=e.getActionCommand();
  			
  			if (e.getSource()==setCpuTh){
  				prm.setCpuThreshold(Float.parseFloat(s));
  				cpuTh.setText(s);
  	  	  cpuTh.repaint();
  	  	  setCpuTh.setText("");
  	  	  setCpuTh.repaint();
  			}
  			if (e.getSource()==setMemTh){
  				prm.setMemThreshold(Float.parseFloat(s));
  				memTh.setText(s);
  	  	  memTh.repaint();
  	  	  setMemTh.setText("");
  	  	  setMemTh.repaint();

  			}
  		  if (e.getSource()==setBandTh){
  				prm.setBand_widthThreshold(Float.parseFloat(s));
  				bandTh.setText(s);
  	  	  bandTh.repaint();
  	  	  setBandTh.setText("");
  	  	  setBandTh.repaint();

  			}
        if (e.getSource()==setFileInTh){
  				prm.setFile_inThreshold(Float.parseFloat(s));
  				fileInTh.setText(s);
  	  	  fileInTh.repaint();
  	  	  setFileInTh.setText("");
  	  	  setFileInTh.repaint();

  			}
  			if (e.getSource()==setFileOutTh){
  				prm.setFile_outThreshold(Float.parseFloat(s));
  				fileOutTh.setText(s);
  	  	  fileOutTh.repaint();
  	  	  setFileOutTh.setText("");
  	  	  setFileOutTh.repaint();

  			}

     	}//actionPerformed
  

  	
  }// Panel1
  	
  	
  	private class Panel2 extends JPanel implements ActionListener{
  	JButton setDef;
  	
  	public Panel2(){
  		setDef=new JButton("SET DEFAULT THRESHOLDS ", new ImageIcon(PICTURE_PATH+"PoliUpdate.gif"));
		  add(setDef);
		  setDef.addActionListener(this);
		  
  	}
  	
  	public void actionPerformed(ActionEvent e) {
		  Object pulsantePremuto = e.getSource();
		  if (pulsantePremuto==setDef){
			  prm.setDefaultAllThresholds();
			  pan1.th=prm.getConsumptionThresholds();
        pan1.cpuTh.setText(Float.toString(pan1.th.cpu));
        pan1.memTh.setText(Float.toString(pan1.th.mem));
        pan1.bandTh.setText(Float.toString(pan1.th.band_width));
        pan1.fileInTh.setText(Float.toString(pan1.th.file_in));
        pan1.fileOutTh.setText(Float.toString(pan1.th.file_out));
	   	}
		  
	  }
  } //Panel2


}
    


	