package SOMA.resourceManagement.windows;


import SOMA.resourceManagement.res.*;

import javax.swing.table.*;
import javax.swing.*;
import java.awt.*;



class ProcessWinDet extends Box{

protected Box info;
protected ThreadData thData;

public ProcessWinDet(){
	super(BoxLayout.X_AXIS);
	info=new Box(BoxLayout.Y_AXIS);
	thData=new ThreadData();
	add(info);
	JTable tab;
	tab=new JTable(thData);
	tab.setDefaultRenderer(Integer.class,thData);
	add(new JScrollPane(tab));
	//tutto vuoto
	}


public void update(ProcessInfo data){
	info.removeAll();
	info.add(new JLabel("Process: "+data.name));
	info.add(new JLabel("PID: "+data.pid));
	info.add(new JLabel("Physical memory: "+data.phys_mem+" bytes"));
	info.add(new JLabel("Virtual memory: "+data.virt_mem+" bytes"));
	info.add(new JLabel("Elapsed time: "+new Time(data.time)));
	thData.update(data.thread);
	validate();
	repaint();
	}



class ThreadData extends AbstractTableModel implements TableCellRenderer{

  protected ThreadInfo[] data=null;
  protected String[] head={"thread","CPU",""};

  public void update(ThreadInfo[] data){
	  this.data=data;
	  fireTableDataChanged();
	}


  public int getColumnCount()
	  {return 3;}


  public String getColumnName(int columnIndex)
	  {return head[columnIndex];}


  public int getRowCount(){
    if(data==null) return 0;
	  return data.length;
  }


  public Object getValueAt(int r, int c) {
    switch(c){
  	  case 0:return "thread-"+(r+1);
  	  case 1:return (int)data[r].cpu+"%";
  	  case 2:return new Integer((int)data[r].cpu);
    }
    return null;
  }


  public Class getColumnClass(int c){
	  if(c==2) return Integer.class;
	  return String.class;
	}


  public Component getTableCellRendererComponent(JTable table, Object value,
          boolean isSelected, boolean hasFocus, int r, int c) {
	  if(value instanceof Integer)
		  return new CpuBar(((Integer)value).intValue());
	  return new JLabel("?");
	}

 }	//ThreadData


}


