package SOMA.resourceManagement.windows;


import SOMA.resourceManagement.*;
import SOMA.resourceManagement.res.*;

import javax.swing.*;
import javax.swing.table.*;
import java.awt.*;
import javax.swing.event.*;



public class ProcessWinData extends AbstractTableModel
	implements TableCellRenderer,ListSelectionListener,MonitoringManagerListener{

protected String[] head={"Name","CPU","","Memory",""};

protected ProcessWinDet detail;
protected int current_detail;
protected ProcessInfo[] data;
protected PlaceResourceManager prm;


public ProcessWinData(PlaceResourceManager prm){
		super();
		this.prm = prm;
		prm.monitoringManager.addMonitoringManagerListener(this);
    data=null;
	  current_detail=0;
	  detail=new ProcessWinDet();
	}


public void update(ProcessInfo[] data){
  this.data=data;
  fireTableDataChanged();
  if(current_detail>=data.length) current_detail=0;
  detail.update(data[current_detail]);
	}


public int getColumnCount()
	{return 5;}


public String getColumnName(int columnIndex)
	{return head[columnIndex];}


public int getRowCount() {
  if(data==null) return 0;
	return data.length;
  }


public Object getValueAt(int r, int c) {
  switch(c){
  	case 0:return data[r].name;
  	case 1:return ((int)data[r].cpu)+"%";
  	case 2:return new Integer((int)data[r].cpu);
    case 3:if(data[r].phys_mem<1048576)
             return data[r].phys_mem/1024+"K";
           return data[r].phys_mem/1048576+"M";
    case 4:return new Integer((int)data[r].phys_mem);
    }
  return null;
  }


public Class getColumnClass(int c){
	if(c==2 || c==4) return Integer.class;
	return String.class;
	}


public Component getTableCellRendererComponent(JTable table, Object value,
          boolean isSelected, boolean hasFocus, int r, int c) {
	if(value instanceof Integer){
		if(c==2) return new CpuBar(((Integer)value).intValue());
		if(c==4) return new MemBar(((Integer)value).intValue(),(int)data[r].total_mem/8);
		}
	return new JLabel("?");
	}


public void valueChanged(ListSelectionEvent e){
  current_detail=e.getLastIndex();
  detail.update(data[current_detail]);
	}


public ProcessWinDet getDetail()
	{return detail;}


public void exit()
	{prm.monitoringManager.removeMonitoringManagerListener(this);}


public void alarm(MonitoringManagerEvent ev){}
public void update(AgentInfo[] data){}
public void update(NetworkInfo data){}




}