package SOMA.resourceManagement.windows;


import SOMA.Environment;
import SOMA.gui.*;


import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.io.*;

/** 
 * Finestra che consente di avviare il monitoraggio, scegliere quali informazioni 
 * sul place visualizzare, attivare/disattivare i controlli.
 * 
 * @see SOMA.resourceManagement.windows.AgentWin
 * @see SOMA.resourceManagement.windows.ProcessWin
 * @see SOMA.resourceManagement.windows.NetworkWin
 * @see SOMA.resourceManagement.windows.ThresholdWin
 * @see SOMA.resourceManagement.windows.AlarmWin
 *
 * @author Silvia Vecchi
 */


public class PRMWindow extends JFrame implements WindowListener {
	
	public static final  String PICTURE_PATH = "SOMA"+File.separator+"gui"+File.separator+"picture"+File.separator;

	protected Panel1 pan1;
	protected Panel2 pan2;
	protected Panel3 pan3;
	protected Container cont;
	protected Environment env;
	//non  molto bello, ma la classe che contiene i dati viene aggiornata dal prm
	//al quale deve registrarsi...
	
	public PRMWindow(Environment env) {
		super("Place Resource Manager");
		this.env=env;
		setBounds(230,200,550,400);
		cont=getContentPane();
		pan1=new Panel1();
		cont.add(pan1, BorderLayout.NORTH);
		pan2=new Panel2();
		pan2.setLayout(new GridLayout(5,1,8,8));
	  cont.add(pan2, BorderLayout.CENTER);
	  pan3=new Panel3(env.placeResourceManager.getCtrlStatus());
	  cont.add(pan3, BorderLayout.SOUTH);	
		setVisible(true);
	}
	
	
	public void windowOpened(WindowEvent e){}
  public void windowClosing(WindowEvent e)
  	{dispose();}
  public void windowClosed(WindowEvent e){}
  public void windowIconified(WindowEvent e){}
  public void windowDeiconified(WindowEvent e){}
  public void windowActivated(WindowEvent e){}
  public void windowDeactivated(WindowEvent e){}

  private class Panel1 extends JPanel{
  	JLabel label1;
  	JRadioButton start, stop;
  	RadioButtonHandler handler;
  	ButtonGroup monGroup;
  	  	
  	public Panel1(){
  	  label1=new JLabel("MONITORING (Available for one place per host configuration only):  "); //, new ImageIcon(PICTURE_PATH+"ProfRec.gif"), SwingConstants.LEFT);
		  add(label1);
		  start=new JRadioButton("Start",(env.placeResourceManager.monitoringManager.getStatus().toString()).equals("ON"));
		  add(start);
		  stop=new JRadioButton("Stop",(env.placeResourceManager.monitoringManager.getStatus().toString()).equals("OFF"));
		  add(stop);
		  		  
		  handler=new RadioButtonHandler();
		  start.addItemListener(handler);
		  stop.addItemListener(handler);
		  
		  monGroup=new ButtonGroup();
		  monGroup.add(start);
		  monGroup.add(stop);
		  	  
  	}
  	
  	private class RadioButtonHandler implements ItemListener{
  		public void itemStateChanged(ItemEvent e){
  			if (e.getSource() == start)
  				try{env.placeResourceManager.monitoringManager.start();}
  				catch(Exception ex)	{ Debug.outln(ex.toString());}
  			else 
  				try{env.placeResourceManager.monitoringManager.stop();}
  				catch(Exception ex)	{ Debug.outln(ex.toString());}
  		}
  	}//RadioButtonHandler

  } //Panel1


  private class Panel2 extends JPanel implements ActionListener{
  	JButton agenti, soglie, proc, rete, allarmi;
  	
  	public Panel2(){
  		agenti=new JButton("  Agent Monitor", new ImageIcon(PICTURE_PATH+"Persone.gif"));
		  proc=new JButton("  Process Monitor", new ImageIcon(PICTURE_PATH+"ThreadVariMaxi.gif"));
		  rete=new JButton("  Network Monitor", new ImageIcon(PICTURE_PATH+"CAAdCon.gif"));
		  soglie=new JButton("  Consumption Thresholds", new ImageIcon(PICTURE_PATH+"PropMaxi.gif"));
		  allarmi=new JButton("  Alarm Number", new ImageIcon(PICTURE_PATH+"Esclamativo.gif"));
		  add(agenti);
		  add(proc);
		  add(rete);
		  add(soglie);
		  add(allarmi);
	  	agenti.addActionListener(this);
		  proc.addActionListener(this);	
	    rete.addActionListener(this);
	    soglie.addActionListener(this);
	    allarmi.addActionListener(this);
  	}
  	
  	public void actionPerformed(ActionEvent e) {
		  Object pulsantePremuto = e.getSource();
		  if (pulsantePremuto==agenti){
			  new AgentWin(env.placeResourceManager);
	   	}
		  if (pulsantePremuto==soglie){
		    new ThresholdWin(env.placeResourceManager);
		  }
      if (pulsantePremuto==proc){
	  		new ProcessWin(env.placeResourceManager);
	    }
      if (pulsantePremuto==rete){
		  	new NetworkWin(env.placeResourceManager);
		  }
      if (pulsantePremuto==allarmi){ 
			  new AlarmWin(env.placeResourceManager);
		  }
	  }
  } //Panel2
  	
  	
  private class Panel3 extends JPanel{
  	JLabel label;
  	JRadioButton on, off;
  	RadioButtonHandler handler;
  	ButtonGroup ctrlGroup;
  	  	
  	public Panel3(boolean ctrl){
  	  label=new JLabel("Consumption control and alarm handling:  ", new ImageIcon(PICTURE_PATH+"ProfRec.gif"), SwingConstants.LEFT);
		  add(label);
		  on=new JRadioButton("On", ctrl==true);
		  add(on);
		  off=new JRadioButton("Off", ctrl==false);
		  add(off);
		  
		  handler=new RadioButtonHandler();
		  on.addItemListener(handler);
		  off.addItemListener(handler);
		  
		  ctrlGroup=new ButtonGroup();
		  ctrlGroup.add(on);
		  ctrlGroup.add(off);
		  	  
  	}
  	
  	private class RadioButtonHandler implements ItemListener{
  		public void itemStateChanged(ItemEvent e){
  			if (e.getSource() == on)
  				env.placeResourceManager.setCtrlStatus(true);
  			else 
  				env.placeResourceManager.setCtrlStatus(false);
  		}
  	}//RadioButtonHandler

  } //Panel3

}
    


	