package SOMA.resourceManagement.windows;

import SOMA.resourceManagement.*;
import SOMA.resourceManagement.res.*;

import javax.swing.*;
import java.awt.*;


public class NetworkWinData extends Box implements MonitoringManagerListener{

protected NetworkWinGraph[] g;
protected PlaceResourceManager prm;

public NetworkWinData(PlaceResourceManager prm){
		super(BoxLayout.Y_AXIS);
		this.prm = prm;
		prm.monitoringManager.addMonitoringManagerListener(this);
		g=new NetworkWinGraph[3];
	  g[0]=new NetworkWinGraph("TCP segments",Color.blue);
	  g[1]=new NetworkWinGraph("UDP packets",Color.pink);
	  g[2]=new NetworkWinGraph("IP packets",Color.cyan);
	  add(g[0]);
    add(g[1]);
	  add(g[2]);
	}


public void update(NetworkInfo data){
	g[0].update(data.tcp_seg_in,data.tcp_seg_out);
	g[1].update(data.udp_pack_in,data.udp_pack_out);
	g[2].update(data.ip_pack_in,data.ip_pack_out);
	}

public void exit()
	{prm.monitoringManager.removeMonitoringManagerListener(this);}


public void alarm(MonitoringManagerEvent ev){}
public void update(ProcessInfo[] info){}
public void update(AgentInfo[] info){}




class NetworkWinGraph extends JComponent{

protected int[] sample_in;
protected int[] sample_out;
protected final static int SAMPLES=10;
protected int scale=3;  //fondoscala in unit da 10
protected Color color;

public NetworkWinGraph(String title,Color color){
	setName(title);
	this.color=color;
	sample_in=new int[SAMPLES];
	sample_out=new int[SAMPLES];
	}


public void update(int newin,int newout){
	int i,max;
	for(i=1;i<SAMPLES;i++){
		sample_in[i-1]=sample_in[i];  //shift
		sample_out[i-1]=sample_out[i];  //shift
		}
	sample_in[SAMPLES-1]=newin;
	sample_out[SAMPLES-1]=newout;
	max=1;
	for(i=0;i<SAMPLES;i++){
		 if(sample_in[i]>max) max=sample_in[i];
	   if(sample_out[i]>max) max=sample_out[i];
	   }
	scale=(max-1)/10+1;
	repaint();
	}


public void paint(Graphics g){
	Dimension d=getSize(null);
  int i;
  int x,y,larg,alt;
  g.setColor(Color.black);

  //griglia
  g.drawRect(20,10,d.width-30,d.height-30);
  for(i=1;i<=scale;i++){
  	g.drawLine(20,d.height-20-((d.height-30)*i/scale),
  		      	 d.width-10,d.height-20-((d.height-30)*i/scale));
  	g.drawString(i+"0",5,d.height-15-((d.height-30)*i/scale));
  	}

  //titoli
  g.drawString(getName()+" in",40,d.height-5);
  g.drawString(getName()+" out",
  	           (d.width-60)/2+70,d.height-5);

  //barre
  larg=(d.width-60)/2/SAMPLES;
  x=20;
  for(i=0;i<SAMPLES;i++){
		alt=(d.height-30)*sample_in[i]/scale/10;
		g.setColor(color);
		g.fillRect(x,d.height-20-alt,larg,alt);
		g.setColor(Color.black);
		g.drawRect(x,d.height-20-alt,larg,alt);
		x+=larg;
		}
  x=(d.width-60)/2+50;
  for(i=0;i<SAMPLES;i++){
		alt=(d.height-30)*sample_out[i]/scale/10;
		g.setColor(color);
		g.fillRect(x,d.height-20-alt,larg,alt);
		g.setColor(Color.black);
		g.drawRect(x,d.height-20-alt,larg,alt);
		x+=larg;
		}
	}

 }	//NetworkWinGraph


} //NetworkWinData