package SOMA.resourceManagement.windows;


import SOMA.resourceManagement.*;

import java.awt.event.*;
import javax.swing.*;

/** 
 * Finestra che visualizza le informazioni relative alla rete dell'host.
 * 
 * @see SOMA.resourceManagement.PlaceResourceManager
 * @see SOMA.resourceManagement.windows.AgentWin
 * @see SOMA.resourceManagement.windows.ProcessWin
 * @see SOMA.resourceManagement.windows.ThresholdWin
 * @see SOMA.resourceManagement.windows.AlarmWin
 * @see SOMA.resourceManagement.windows.PRMWindow
 *
 * @author Luca Armani
 */

class NetworkWin extends JFrame implements ActionListener, WindowListener{

PlaceResourceManager prm;
NetworkWinData data;

public NetworkWin(PlaceResourceManager prm){
  super("Network Monitor");
  this.prm=prm;
  setBounds(660,0,350,460);
  setJMenuBar(myMenuBar());
  addWindowListener(this);
  data=new NetworkWinData(prm);
  getContentPane().add(data);
  setVisible(true);
  }



public void actionPerformed(ActionEvent e){
  Object x=e.getSource();
  String label;
  if(x instanceof JMenuItem){
    label=((JMenuItem)x).getText();
    if(label.equals("About...")) help();
  }
}



public void help(){
  JOptionPane.showMessageDialog(null,
    "University of Bologna\n9/2/2000\n\nNetwork Monitor \nwritten with JNI v1.2",
    "About",JOptionPane.INFORMATION_MESSAGE);    
  }


protected JMenuBar myMenuBar(){
  JMenuBar menubar;
  JMenu menu;
  JMenuItem elem;
  menubar=new JMenuBar();
  menu=new JMenu("Help");
  elem=new JMenuItem("About...");
  elem.addActionListener(this);
  menu.add(elem);
  menubar.add(menu);  
  return menubar;
  }  
  

public void windowOpened(WindowEvent e){}
public void windowClosing(WindowEvent e)
  {dispose(); data.exit(); }
public void windowClosed(WindowEvent e){}
public void windowIconified(WindowEvent e){}
public void windowDeiconified(WindowEvent e){}
public void windowActivated(WindowEvent e){}
public void windowDeactivated(WindowEvent e){}

}